using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using gov.va.med.vbecs.Common;
using ORDEREDTEST = gov.va.med.vbecs.Common.VbecsTables.OrderedTest;
using VALIDABORESULT = gov.va.med.vbecs.Common.VbecsTables.ValidAboResult;
using VALIDRHRESULT = gov.va.med.vbecs.Common.VbecsTables.ValidRhResult;
namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// FrmRecordTesting
	/// </summary>
	public class FrmRecordTesting : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Button btnBack;
		private System.Windows.Forms.Button btnNext;
		private gov.va.med.vbecs.GUI.controls.PatientSpecimenDisplayPanel patientSpecimenDisplayPanel1;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbName;
		private System.Windows.Forms.ContextMenu contextMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.GroupBox grpRackDate;
		private System.Windows.Forms.TextBox txtRack;
		private System.Windows.Forms.Label lblRack;
		private System.Windows.Forms.Label lblDateTested;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnNewSIorTR;
		private System.Windows.Forms.Button btnOrderReflex;
		private System.Windows.Forms.TextBox txtDateTested;
		private System.Windows.Forms.TabPage pagePatientTests;
		private System.Windows.Forms.Panel pnlTesting;
		private System.Windows.Forms.GroupBox grpTestingValidEntries;
		private System.Windows.Forms.Label lblTestingValidEntries;
		private gov.va.med.vbecs.GUI.controls.DataGridXMatch dgXMatch;
		private gov.va.med.vbecs.GUI.controls.DataGridDat dgDAT;
		private gov.va.med.vbecs.GUI.controls.DataGridAbs dgABS;
		private System.Windows.Forms.Panel pnlTop;
		private gov.va.med.vbecs.GUI.controls.DataGridAboRH dgABORh;
		private System.Windows.Forms.TabPage pageSupplementalTests;
		private gov.va.med.vbecs.GUI.controls.DataGridDatC3 dataGridDATC31;
		private gov.va.med.vbecs.GUI.controls.DataGridDatIgG dataGridDATIgG1;
		private System.Windows.Forms.TabControl tabTesting;
		private System.Windows.Forms.TextBox txtTestedBy;
		private System.Windows.Forms.Label lblTestedBy;
		private System.ComponentModel.IContainer components = null;
		private DateTime _testingDateTime;
		private Common.TestingMethod _testMethod;
		private string _testingTechID;
		private Common.ReactivityPhase _reactivityPhase;
		private Guid _RackGuid;
		private ArrayList _rackNotTestedExceptions;

		/// <summary>
		/// The list of the DataSets (one per patient) that contain 
		/// the DataTables (one per test/task) that drive the test grids
		/// </summary>
		private ArrayList _dsPatientTestGrids;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.GroupBox groupBox4;
		private System.Windows.Forms.Label label14;
		private System.Windows.Forms.Label label15;
		private System.Windows.Forms.Label label16;
		private System.Windows.Forms.TextBox txtLotNumber;
		private System.Windows.Forms.TextBox txtExpirationDate;
		private System.Windows.Forms.TextBox txtManufacturer;
		private System.Windows.Forms.TabPage pageAntibodyID;
		private Hashtable antibodyIDs;
		private gov.va.med.vbecs.GUI.controls.AntigenTypingWeakD antigenTypingWeakD;
		private bool _closeForm;
		private ArrayList _orderedTests;
		private ArrayList _orderedComponents;
		string _automatedInstrumentName;
		bool _automatedInstrumentQCd;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.Label label7;
		private System.Windows.Forms.Label label8;
		private System.Windows.Forms.Label label9;
		private System.Windows.Forms.Label label10;
		private System.Windows.Forms.Label label11;
		private System.Windows.Forms.Label label12;
		private System.Windows.Forms.GroupBox groupBox3;
		private System.Windows.Forms.Label lblValidEntriesForAdditionalTests;
		private System.Windows.Forms.Panel pnlDATReflex;
		private gov.va.med.vbecs.GUI.controls.AntibodyID antibodyID;
		private ArrayList _expiredOrderExceptions;
		

		/// <summary>
		/// The index of an active patient in _dsPatientTestGrids
		/// </summary>
		private int ActivePatient;


		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="orderedTests"></param>
		/// <param name="orderedComponents"></param>
		/// <param name="drRack"></param>
		/// <param name="testingUserName"></param>
		/// <param name="testingDateTime"></param>
		/// <param name="reactivityPhase"></param>
		/// <param name="automatedInstrName"></param>
		/// <param name="automatedInstrQcd"></param>
		/// <param name="rackNotTestedExceptions"></param>
		/// <param name="expiredOrderExceptions"></param>
		public FrmRecordTesting(ArrayList orderedTests, ArrayList orderedComponents, 
								DataRow drRack, string testingUserName, DateTime testingDateTime, 
								Common.ReactivityPhase reactivityPhase, string automatedInstrName, 
								bool automatedInstrQcd, ArrayList rackNotTestedExceptions, ArrayList expiredOrderExceptions)
		{
			this._closeForm = true;

			this.LockController.LockFunction = Common.LockFunctions.UC056RecordTesting;

			//Grab the OrderedTest records, and any OrderedUnit records associated. 
            //TODO Before Locking 2.0 OT record was not released in btnOK_Click - is this OK?
			foreach (BOL.OrderedTest tmpOT in orderedTests)
			{
				this.LockController.RecordGuids.Add(tmpOT.OrderedTestGuid);
			}

			//Grab the OrderedUnit records from the OrderedComponent objects
			foreach (BOL.OrderedComponent tmpOC in orderedComponents)
			{
				System.Data.DataTable dtOrderedUnits = BOL.OrderedUnit.GetOrderedUnitsForRepeatXM(System.Guid.Empty, tmpOC.OrderedComponentGuid);
				foreach(System.Data.DataRow drOU in dtOrderedUnits.Rows)
				{	//We don't care about OrderedUnits that have already been crossmatched
					if (drOU.IsNull(Common.VbecsTables.OrderedUnit.CrossmatchResultCode))
					{
                        this.LockController.RecordGuids.Add((System.Guid)drOU[Common.VbecsTables.OrderedUnit.OrderedUnitGuid]);
					}
				}				
			}

			if (!this.SetLocks())
			{
				this.DialogResult = DialogResult.Abort;	//Unnessesary, cuz here -- _closeForm is how this was UC is coded
				return;
			}

			this._rackNotTestedExceptions = rackNotTestedExceptions;
			this._expiredOrderExceptions = expiredOrderExceptions;
			this._automatedInstrumentName = automatedInstrName;
			this._automatedInstrumentQCd = automatedInstrQcd;
			
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			//Connect the locking for all our grids...
			this.dgABORh.UserActivity += new EventHandler(this.ResetLockTimer);
			//this.dgABORh.ParentFormGuid = this.FormInstanceGuid;

			this.dgABS.UserActivity += new EventHandler(this.ResetLockTimer);
			//this.dgABS.ParentFormGuid = this.FormInstanceGuid;

			this.dgDAT.UserActivity += new EventHandler(this.ResetLockTimer);
			//this.dgDAT.ParentFormGuid = this.FormInstanceGuid;
			
			this.dgXMatch.UserActivity += new EventHandler(this.ResetLockTimer);
			//this.dgXMatch.ParentFormGuid = this.FormInstanceGuid;
			
			this.dataGridDATC31.UserActivity += new EventHandler(this.ResetLockTimer);
			//this.dataGridDATC31.ParentFormGuid = this.FormInstanceGuid;
			
			this.dataGridDATIgG1.UserActivity += new EventHandler(this.ResetLockTimer);
			//this.dataGridDATIgG1.ParentFormGuid = this.FormInstanceGuid;
			//End locking code


			this.antibodyIDs = new Hashtable();

			this._orderedTests = orderedTests;
			this._orderedComponents = orderedComponents;
			this._testingDateTime = testingDateTime;

			_testingTechID = ( testingUserName != null ) ? testingUserName : String.Empty;

			this._reactivityPhase = reactivityPhase;

			if (drRack.ItemArray.Length != 0)
			{
				this._RackGuid = (Guid)drRack[Common.VbecsTables.Rack.RackGuid];
			}
			else //Transfusion-Only
			{
				this._RackGuid = Guid.Empty;
			}

			this._closeForm = false;

			SetComponentProperties();

			this.txtDateTested.Text = Common.VBECSDateTime.FormatDateTimeString(testingDateTime);
			
			try
			{
				txtTestedBy.Text = new BOL.VbecsUser( testingUserName ).UserName;
			}
			catch
			{
				txtTestedBy.Text = string.Empty;
			}

			if (drRack.ItemArray.Length != 0)
			{
				this.txtRack.Text = drRack[Common.VbecsTables.Rack.RackName].ToString();
			}
			else
			{
				this.txtRack.Text = string.Empty ;
			}

			_dsPatientTestGrids = new ArrayList();
			ActivePatient = 0;

			Guid PatientGuid = Guid.Empty;
			DataSet dsPatientTests = null;

			//Set up DataTable for each test and add them to DataSet for each patient
			//Add DataSets to the _dsPatientTestGrids
			if (orderedTests != null)
			{
				foreach(BOL.OrderedTest Test in orderedTests)
				{
					dsPatientTests = null;

					//trying to find the existing DataSet for a patient
					foreach (DataSet dsPatient in this._dsPatientTestGrids)
					{
						if ((Guid)dsPatient.Tables[Common.VbecsTables.Patient.TableName].Rows[0][Common.VbecsTables.Patient.PatientGuid] == Test.Patient.PatientGuid)
							dsPatientTests = dsPatient;
					}

					//if it does not exist yet create it
					if (dsPatientTests == null)
					{
						//CR 2667 - used BuildDispalyName method to create the name instead of building it manually
						this.cmbName.Items.Add(BOL.Patient.BuildDisplayName(Test.Patient.FirstName, Test.Patient.MiddleInitial, Test.Patient.LastName));

						dsPatientTests = new DataSet(PatientGuid.ToString());

						//Add DataTable containing patient data to the DataSet
						dsPatientTests.Tables.Add(this.GetPatientDataTable(Test));
						this._dsPatientTestGrids.Add(dsPatientTests);
					}

					dsPatientTests.CaseSensitive = true;
					//create the DataTable that drives the grid for each test
					if (Test.OrderableTestId == (int)Common.OrderableTest.ABORh ||
						Test.OrderableTestId == (int)Common.OrderableTest.RepeatABORh)
					{
						string previousABO = dsPatientTests.Tables[Common.VbecsTables.Patient.TableName].Rows[0][Common.VbecsTables.Patient.BloodTypeCode].ToString();
						string previousRh = dsPatientTests.Tables[Common.VbecsTables.Patient.TableName].Rows[0][Common.VbecsTables.Patient.RhFactorCode].ToString();
						DataTable dtABORh = this.dgABORh.CreateAboRHTable(Test, this._RackGuid, previousABO, previousRh);
						if (Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
						{
							BOL.SpecimenTest.BuildABORhFromSpecimenTest(dtABORh.Rows[0], Test.OrderedTestGuid, Test.OrderableTestId.ToString());
						}
						if (dsPatientTests.Tables.IndexOf(dtABORh.TableName) == -1)
							dsPatientTests.Tables.Add(dtABORh);
					}
					else if (Test.OrderableTest.Replace("Repeat", string.Empty ).Trim().Substring(0, 2) == "AG")
					{
						DataTable dtAGT = this.antigenTypingWeakD.CreateAgtTable(Test, this._RackGuid);
						if (Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
						{
							BOL.SpecimenTest.BuildAGTFromSpecimenTest(dtAGT, Test);
						}
						dtAGT.CaseSensitive = true;
						bool add = true;
						foreach(DataTable dt in dsPatientTests.Tables)
						{
							if (dt.TableName == dtAGT.TableName)
							{
								add = false;
								break;
							}
						}

						if (add == true)
							dsPatientTests.Tables.Add(dtAGT);
					}
					else if (Test.OrderableTestId == (int)Common.OrderableTest.ABS ||
						Test.OrderableTestId == (int)Common.OrderableTest.RepeatABS)
					{
						bool createDAT = false;

						this.AddABSTest(Test, ref dsPatientTests);
						if (Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted) ||
							Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
						{
							DataTable dt = BOL.OrderedTest.GetTestResultsForTask(Test.OrderedTestGuid);
							foreach(DataRow dr in dt.Rows)
							{
								if (dr[Common.VbecsTables.BloodTestType.BloodTestName].ToString().IndexOf("DAT") != -1)
								{
									createDAT = true;
									break;
								}
							}

							if (createDAT == false)
							{
								dt = BOL.OrderedTest.GetTestResultsWithErrorForTask(Test.OrderedTestGuid);
								foreach(DataRow dr in dt.Rows)
								{
									if (dr[Common.VbecsTables.BloodTestType.BloodTestName].ToString().IndexOf("DAT") != -1)
									{
										createDAT = true;
										break;
									}
								}
							}
						}
						else
						{
							if (ThisUser.CurrentDivisionRole.Division.PatientTestingConfiguration == Common.PatientTestingConfiguration.AntibodyDAT)
							{
								createDAT = true;
							}
						}

						if (createDAT == true)
						{
							this.dgABS.DATExists = true;
							DataTable dtDAT = this.dgDAT.CreateDatTable(Test, this._RackGuid);
							if (Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted) ||
								Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
							{
								BOL.SpecimenTest.BuildDATFromSpecimenTest(dtDAT, Test.OrderedTestGuid, ((int)Common.OrderableTest.DAT).ToString());
							}
							if (dsPatientTests.Tables.IndexOf(dtDAT.TableName) == -1)
								dsPatientTests.Tables.Add(dtDAT);
						}
						else
						{
							this.dgABS.DATExists = false;
						}
					}
					else if (Test.OrderableTestId == (int)Common.OrderableTest.DAT ||
						Test.OrderableTestId == (int)Common.OrderableTest.RepeatDAT)
					{
						DataTable dtDAT = this.dgDAT.CreateDatTable(Test, this._RackGuid);
						if (Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
						{
							BOL.SpecimenTest.BuildDATFromSpecimenTest(dtDAT, Test.OrderedTestGuid, Test.OrderableTestId.ToString());
						}
						if (dsPatientTests.Tables.IndexOf(dtDAT.TableName) == -1)
							dsPatientTests.Tables.Add(dtDAT);
					}
					else if (Test.OrderableTestId == (int)Common.OrderableTest.DATIgG ||
						Test.OrderableTestId == (int)Common.OrderableTest.RepeatDATIgG)
					{
						DataTable dtDATIgG = this.dataGridDATIgG1.CreateDatIgGTable(Test, this._RackGuid);
						if (Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
						{
							BOL.SpecimenTest.BuildDATFromSpecimenTest(dtDATIgG, Test.OrderedTestGuid, Test.OrderableTestId.ToString());
						}
						if (dsPatientTests.Tables.IndexOf(dtDATIgG.TableName) == -1)
							dsPatientTests.Tables.Add(dtDATIgG);
					}
					else if (Test.OrderableTestId == (int)Common.OrderableTest.DATComp ||
						Test.OrderableTestId == (int)Common.OrderableTest.RepeatDATComp)
					{
						DataTable dtDATC3d = this.dataGridDATC31.CreateDatC3Table(Test, this._RackGuid);
						if (Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
						{
							BOL.SpecimenTest.BuildDATFromSpecimenTest(dtDATC3d, Test.OrderedTestGuid, Test.OrderableTestId.ToString());
						}
						if (dsPatientTests.Tables.IndexOf(dtDATC3d.TableName) == -1)
							dsPatientTests.Tables.Add(dtDATC3d);
					}
					else if (Test.OrderableTestId == (int)Common.OrderableTest.TAS)
					{
						bool createDAT = false;
						//TAS is ABO/Rh + ABS + DAT
						string previousABO = dsPatientTests.Tables[Common.VbecsTables.Patient.TableName].Rows[0][Common.VbecsTables.Patient.BloodTypeCode].ToString();
						string previousRh = dsPatientTests.Tables[Common.VbecsTables.Patient.TableName].Rows[0][Common.VbecsTables.Patient.RhFactorCode].ToString();
						DataTable dtABORh = this.dgABORh.CreateAboRHTable(Test, this._RackGuid, previousABO, previousRh);
						if (Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted) ||
							Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
						{
							BOL.SpecimenTest.BuildABORhFromSpecimenTest(dtABORh.Rows[0], Test.OrderedTestGuid, Test.OrderableTestId.ToString());
						}
						if (dsPatientTests.Tables.IndexOf(dtABORh.TableName) == -1)
							dsPatientTests.Tables.Add(dtABORh);

						this.AddABSTest(Test, ref dsPatientTests);

						if (Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted) ||
							Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
						{
							DataTable dt = BOL.OrderedTest.GetTestResultsWithErrorForTask(Test.OrderedTestGuid);
							foreach(DataRow dr in dt.Rows)
							{
								if (dr[Common.VbecsTables.BloodTestType.BloodTestName].ToString().IndexOf("DAT") != -1)
								{
									createDAT = true;
									break;
								}
							}

							if (createDAT == false)
							{
								dt = BOL.OrderedTest.GetTestResultsForTask(Test.OrderedTestGuid);
								foreach(DataRow dr in dt.Rows)
								{
									if (dr[Common.VbecsTables.BloodTestType.BloodTestName].ToString().IndexOf("DAT") != -1)
									{
										createDAT = true;
										break;
									}
								}
							}
						}
						else
						{
							if (ThisUser.CurrentDivisionRole.Division.PatientTestingConfiguration == Common.PatientTestingConfiguration.AntibodyDAT)
							{
								createDAT = true;
							}
						}

						if (createDAT == true)
						{
							this.dgABS.DATExists = true;
							DataTable dtDAT = this.dgDAT.CreateDatTable(Test, this._RackGuid);
							if (Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted) ||
								Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
							{
								BOL.SpecimenTest.BuildDATFromSpecimenTest(dtDAT, Test.OrderedTestGuid, ((int)Common.OrderableTest.TAS).ToString());
							}
							if (dsPatientTests.Tables.IndexOf(dtDAT.TableName) == -1)
								dsPatientTests.Tables.Add(dtDAT);
						}
						else
						{
							this.dgABS.DATExists = false;
						}
					}
					else if (Test.OrderableTestId == (int)Common.OrderableTest.ABID ||
						Test.OrderableTestId == (int)Common.OrderableTest.RepeatABID)
					{
						//antibodyID control has to be created for each patient separately
						controls.AntibodyID antibodyID = new controls.AntibodyID();
						antibodyID.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
							| System.Windows.Forms.AnchorStyles.Left) 
							| System.Windows.Forms.AnchorStyles.Right);
                          //Defect 227411
                        using (Font _tmpFontRegular = new Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0))))
                        {
                            antibodyID.Font = _tmpFontRegular;
                        }
						antibodyID.Location = new System.Drawing.Point(4, 4);
						antibodyID.Name = "antibodyID";
						antibodyID.Size = new System.Drawing.Size(728, 360);
						antibodyID.TabIndex = 0;

						antibodyID.Initialize();
						DataTable dtABID = antibodyID.CreateAntibodyIDTable();

						ArrayList alWorkloadProcessIds = new ArrayList();
						antibodyID.SetAntibodyIDProcesses(alWorkloadProcessIds);

						if (dsPatientTests.Tables.IndexOf(dtABID.TableName) == -1)
						{
							dsPatientTests.Tables.Add(dtABID);
						}

						antibodyID.OrderedTest = Test;
						antibodyID.DataChanged += new controls.CellChangedEventHandler(this.antibodyID_CurrentDataChanged);

						this.antibodyIDs.Add(Test.Patient.PatientGuid, antibodyID);
					}
					else if (Test.OrderableTestId == (int)Common.OrderableTest.RepeatXM)
					{

								DataTable dtXM = this.dgXMatch.CreateXMTable(Test, this._RackGuid, Common.UpdateFunction.UC056FrmRecordTesting);

								if (dtXM.Rows.Count > 0)
								{
									if (Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted))
									{
										BOL.BloodUnitTest.BuildXMFromBloodUnitTest(dtXM, Test.OrderedTestGuid, Guid.Empty);
									}
									if (dsPatientTests.Tables.IndexOf(dtXM.TableName) == -1 &&
										dtXM.Rows.Count > 0)
										dsPatientTests.Tables.Add(dtXM);
								}
					}
				}
			}

			if (orderedComponents.Count != 0)
			{
				foreach (BOL.OrderedComponent Component in orderedComponents)
				{
					dsPatientTests = null;
							//trying to find the existing DataSet for a patient
							foreach (DataSet dsPatient in this._dsPatientTestGrids)
							{
								if ((Guid)dsPatient.Tables[Common.VbecsTables.Patient.TableName].Rows[0][Common.VbecsTables.Patient.PatientGuid] == Component.Patient.PatientGuid)
									dsPatientTests = dsPatient;
							}

							//if it does not exist yet create it
							if (dsPatientTests == null)
							{
								//CR 2667 - used BuildDispalyName method to create the name instead of building it manually
								this.cmbName.Items.Add(BOL.Patient.BuildDisplayName(Component.Patient.FirstName, Component.Patient.MiddleInitial, Component.Patient.LastName));

								dsPatientTests = new DataSet(PatientGuid.ToString());

								//Add DataTable containing patient data to the DataSet
								dsPatientTests.Tables.Add(this.GetPatientDataTable(Component));
								this._dsPatientTestGrids.Add(dsPatientTests);
							}

							DataTable dtXM = this.dgXMatch.CreateXMTable(Component, this._RackGuid, Common.UpdateFunction.UC056FrmRecordTesting);

							if (dtXM.Rows.Count > 0)
							{
								DataTable dtBloodUnitTests = BOL.BloodUnitTest.GetTestResultsForXM(Guid.Empty, Component.OrderedComponentGuid);

								//check if all test results recorded previously are interps and if not then we should load previously saved results since they were saved in full service division
								if (dtBloodUnitTests.Select(Common.VbecsTables.BloodTestType.BloodTestTypeId + " = 102 OR " + Common.VbecsTables.BloodTestType.BloodTestTypeId + " = 168").Length != dtBloodUnitTests.Rows.Count)
								{
									BOL.BloodUnitTest.BuildXMFromBloodUnitTest(dtXM, Guid.Empty, Component.OrderedComponentGuid);
								}

								if (dtXM.Rows.Count > 0)
								{
									if (dsPatientTests.Tables.IndexOf(dtXM.TableName) == -1)
									{
										dsPatientTests.Tables.Add(dtXM);
									}
									else if (dsPatientTests.Tables.IndexOf(dtXM.TableName) != -1)
									{
										foreach (DataRow drXM in dtXM.Rows)
										{
											dsPatientTests.Tables[dtXM.TableName].Rows.Add(drXM.ItemArray);
										}
									}
								}
							}
				}
			}

			this.dgABORh.CellChanged += new controls.CellChangedEventHandler(this.dgABORh_CurrentCellChanged);
			this.dgABORh.RowVersionChanged += new controls.RowVersionChangedEventHandler(this.RowVersionChanged);
			this.dgABS.CellChanged += new controls.CellChangedEventHandler(this.dgABS_CellChanged);
			this.dgABS.RowVersionChanged += new controls.RowVersionChangedEventHandler(this.RowVersionChanged);
			this.dgDAT.CellChanged += new controls.CellChangedEventHandler(this.dgDAT_CurrentCellChanged);
			this.dgDAT.RowVersionChanged += new controls.RowVersionChangedEventHandler(this.RowVersionChanged);
			this.dataGridDATIgG1.CellChanged += new controls.CellChangedEventHandler(this.dgDATIgG_CurrentCellChanged);
			this.dataGridDATC31.CellChanged += new controls.CellChangedEventHandler(this.dgDATC3d_CurrentCellChanged);
			this.antigenTypingWeakD.CellChanged += new controls.CellChangedEventHandler(this.antigenTypingWeakD_CurrentCellChanged);
			this.antigenTypingWeakD.TabActivated += new controls.TabActivatedEventHandler(this.antigenTypingWeakD_TabActivated);
			this.dgXMatch.CellChanged += new controls.CellChangedEventHandler(this.dgXM_CurrentCellChanged);

			for (int i=this._dsPatientTestGrids.Count-1; i>=0; i--)
			{
				if (((DataSet)this._dsPatientTestGrids[i]).Tables.Count == 1)
				{
					this._dsPatientTestGrids.RemoveAt(i);
					this.cmbName.Items.RemoveAt(i);
				}
			}

			ActivatePatient();
		}

		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/15/2003</CreationDate>
		///
		/// <summary>
		/// Adds data table for an ABS test to dsPatientTests
		/// </summary>
		private void AddABSTest(BOL.OrderedTest Test, ref DataSet dsPatientTests)
		{
			this.dgABS.CreateAbsTable(Test, ThisUser.CurrentDivisionRole.Division.PatientTestingConfiguration == Common.PatientTestingConfiguration.AntibodyAutocontrol, this._RackGuid);
			DataTable dtABS = dgABS.GridDataSource;

			if (Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.PartiallyCompleted) ||
				Test.TaskStatusCode == Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.ResultsCorrected))
			{
				BOL.SpecimenTest.BuildABSFromSpecimenTest(dtABS, Test);
			}

			if (dsPatientTests.Tables.IndexOf(dtABS.TableName) == -1)
				dsPatientTests.Tables.Add(dtABS);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmRecordTesting));
			this.btnCancel = new System.Windows.Forms.Button();
			this.btnBack = new System.Windows.Forms.Button();
			this.btnNext = new System.Windows.Forms.Button();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.contextMenu1 = new System.Windows.Forms.ContextMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.patientSpecimenDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.PatientSpecimenDisplayPanel();
			this.cmbName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.btnNewSIorTR = new System.Windows.Forms.Button();
			this.btnOrderReflex = new System.Windows.Forms.Button();
			this.grpRackDate = new System.Windows.Forms.GroupBox();
			this.txtTestedBy = new System.Windows.Forms.TextBox();
			this.lblTestedBy = new System.Windows.Forms.Label();
			this.txtDateTested = new System.Windows.Forms.TextBox();
			this.txtRack = new System.Windows.Forms.TextBox();
			this.lblRack = new System.Windows.Forms.Label();
			this.lblDateTested = new System.Windows.Forms.Label();
			this.pagePatientTests = new System.Windows.Forms.TabPage();
			this.pnlTesting = new System.Windows.Forms.Panel();
			this.dgXMatch = new gov.va.med.vbecs.GUI.controls.DataGridXMatch();
			this.pnlTop = new System.Windows.Forms.Panel();
			this.dgABORh = new gov.va.med.vbecs.GUI.controls.DataGridAboRH();
			this.dgABS = new gov.va.med.vbecs.GUI.controls.DataGridAbs();
			this.dgDAT = new gov.va.med.vbecs.GUI.controls.DataGridDat();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.label5 = new System.Windows.Forms.Label();
			this.label6 = new System.Windows.Forms.Label();
			this.label4 = new System.Windows.Forms.Label();
			this.grpTestingValidEntries = new System.Windows.Forms.GroupBox();
			this.lblTestingValidEntries = new System.Windows.Forms.Label();
			this.pageSupplementalTests = new System.Windows.Forms.TabPage();
			this.pnlDATReflex = new System.Windows.Forms.Panel();
			this.dataGridDATIgG1 = new gov.va.med.vbecs.GUI.controls.DataGridDatIgG();
			this.dataGridDATC31 = new gov.va.med.vbecs.GUI.controls.DataGridDatC3();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.label7 = new System.Windows.Forms.Label();
			this.label8 = new System.Windows.Forms.Label();
			this.label9 = new System.Windows.Forms.Label();
			this.label10 = new System.Windows.Forms.Label();
			this.label11 = new System.Windows.Forms.Label();
			this.label12 = new System.Windows.Forms.Label();
			this.groupBox3 = new System.Windows.Forms.GroupBox();
			this.lblValidEntriesForAdditionalTests = new System.Windows.Forms.Label();
			this.antigenTypingWeakD = new gov.va.med.vbecs.GUI.controls.AntigenTypingWeakD();
			this.groupBox4 = new System.Windows.Forms.GroupBox();
			this.txtLotNumber = new System.Windows.Forms.TextBox();
			this.label14 = new System.Windows.Forms.Label();
			this.txtExpirationDate = new System.Windows.Forms.TextBox();
			this.label15 = new System.Windows.Forms.Label();
			this.label16 = new System.Windows.Forms.Label();
			this.txtManufacturer = new System.Windows.Forms.TextBox();
			this.tabTesting = new System.Windows.Forms.TabControl();
			this.pageAntibodyID = new System.Windows.Forms.TabPage();
			this.antibodyID = new gov.va.med.vbecs.GUI.controls.AntibodyID();
			this.grpRackDate.SuspendLayout();
			this.pagePatientTests.SuspendLayout();
			this.pnlTesting.SuspendLayout();
			this.pnlTop.SuspendLayout();
			this.groupBox1.SuspendLayout();
			this.grpTestingValidEntries.SuspendLayout();
			this.pageSupplementalTests.SuspendLayout();
			this.pnlDATReflex.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.groupBox3.SuspendLayout();
			this.groupBox4.SuspendLayout();
			this.tabTesting.SuspendLayout();
			this.pageAntibodyID.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(742, 30);
			this.vbecsLogo1.TabIndex = 10;
			this.vbecsLogo1.Title = "Patient Testing";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 517);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 11;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(664, 500);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 12;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// btnBack
			// 
			this.btnBack.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnBack.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnBack.Image = ((System.Drawing.Image)(resources.GetObject("btnBack.Image")));
			this.btnBack.Location = new System.Drawing.Point(128, 38);
			this.btnBack.Name = "btnBack";
			this.btnBack.Size = new System.Drawing.Size(22, 22);
			this.btnBack.TabIndex = 0;
			this.btnBack.Click += new System.EventHandler(this.btnBack_Click);
			// 
			// btnNext
			// 
			this.btnNext.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnNext.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnNext.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnNext.Image = ((System.Drawing.Image)(resources.GetObject("btnNext.Image")));
			this.btnNext.Location = new System.Drawing.Point(372, 38);
			this.btnNext.Name = "btnNext";
			this.btnNext.Size = new System.Drawing.Size(22, 22);
			this.btnNext.TabIndex = 2;
			this.btnNext.Click += new System.EventHandler(this.btnNext_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(584, 500);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 11;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// contextMenu1
			// 
			this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																						 this.menuItem1,
																						 this.menuItem2,
																						 this.menuItem3});
			this.contextMenu1.Popup += new System.EventHandler(this.contextMenu1_Popup);
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.Text = "Clear Results";
			this.menuItem1.Click += new System.EventHandler(this.menuItem1_Click);
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 1;
			this.menuItem2.Text = "Order Reflex";
			this.menuItem2.Click += new System.EventHandler(this.menuItem2_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 2;
			this.menuItem3.Text = "New SI or TR";
			this.menuItem3.Click += new System.EventHandler(this.menuItem3_Click);
			// 
			// patientSpecimenDisplayPanel1
			// 
			this.patientSpecimenDisplayPanel1.AboRh = "";
			this.patientSpecimenDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.patientSpecimenDisplayPanel1.EnabledBloodAvailButton = false;
			this.patientSpecimenDisplayPanel1.EnabledMedicationButton = false;
			this.patientSpecimenDisplayPanel1.EnabledRecentOrdersButton = false;
			this.patientSpecimenDisplayPanel1.EnabledRecentTransfusionsIssuesButton = false;
			this.patientSpecimenDisplayPanel1.EnabledSIAndTRButton = false;
			this.patientSpecimenDisplayPanel1.EnabledTransfusionReactionHistoryButton = false;
			this.patientSpecimenDisplayPanel1.Expires = "";
			this.patientSpecimenDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.patientSpecimenDisplayPanel1.Location = new System.Drawing.Point(4, 26);
			this.patientSpecimenDisplayPanel1.Name = "patientSpecimenDisplayPanel1";
			this.patientSpecimenDisplayPanel1.Patient = null;
			this.patientSpecimenDisplayPanel1.PatientID = "";
			this.patientSpecimenDisplayPanel1.PatientName = "";
			this.patientSpecimenDisplayPanel1.Size = new System.Drawing.Size(736, 66);
			this.patientSpecimenDisplayPanel1.Specimen = null;
			this.patientSpecimenDisplayPanel1.SpecimenID = "";
			this.patientSpecimenDisplayPanel1.TabIndex = 3;
			this.patientSpecimenDisplayPanel1.VbecsInfoClick += new System.EventHandler(this.patientSpecimenDisplayPanel1_VbecsInfoClick);
			this.patientSpecimenDisplayPanel1.SIAndTRClick += new System.EventHandler(this.patientSpecimenDisplayPanel1_SIAndTRClick);
			this.patientSpecimenDisplayPanel1.TransHistoryClick += new System.EventHandler(this.patientSpecimenDisplayPanel1_TransHistoryClick);
			this.patientSpecimenDisplayPanel1.MedicationsClick += new System.EventHandler(this.patientSpecimenDisplayPanel1_MedicationsClick);
			this.patientSpecimenDisplayPanel1.BloodAvailClick += new System.EventHandler(this.patientSpecimenDisplayPanel1_BloodAvailClick);
			this.patientSpecimenDisplayPanel1.ClinicalInfoClick += new System.EventHandler(this.patientSpecimenDisplayPanel1_ClinicalInfoClick);
			// 
			// cmbName
			// 
			this.cmbName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbName.Interval = 1000;
			this.cmbName.Location = new System.Drawing.Point(150, 38);
			this.cmbName.Name = "cmbName";
			this.cmbName.Size = new System.Drawing.Size(224, 22);
			this.cmbName.TabIndex = 1;
			this.cmbName.SelectedIndexChanged += new System.EventHandler(this.cmbName_SelectedIndexChanged);
			// 
			// btnNewSIorTR
			// 
			this.btnNewSIorTR.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnNewSIorTR.Image = ((System.Drawing.Image)(resources.GetObject("btnNewSIorTR.Image")));
			this.btnNewSIorTR.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.btnNewSIorTR.Location = new System.Drawing.Point(424, 500);
			this.btnNewSIorTR.Name = "btnNewSIorTR";
			this.btnNewSIorTR.Size = new System.Drawing.Size(100, 23);
			this.btnNewSIorTR.TabIndex = 10;
			this.btnNewSIorTR.Text = "New SI or TR";
			this.btnNewSIorTR.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnNewSIorTR.Click += new System.EventHandler(this.btnNewSIorTR_Click);
			// 
			// btnOrderReflex
			// 
			this.btnOrderReflex.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOrderReflex.Image = ((System.Drawing.Image)(resources.GetObject("btnOrderReflex.Image")));
			this.btnOrderReflex.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.btnOrderReflex.Location = new System.Drawing.Point(320, 500);
			this.btnOrderReflex.Name = "btnOrderReflex";
			this.btnOrderReflex.Size = new System.Drawing.Size(100, 23);
			this.btnOrderReflex.TabIndex = 9;
			this.btnOrderReflex.Text = "Order &Reflex";
			this.btnOrderReflex.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnOrderReflex.Click += new System.EventHandler(this.btnOrderReflex_Click);
			// 
			// grpRackDate
			// 
			this.grpRackDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpRackDate.Controls.Add(this.txtTestedBy);
			this.grpRackDate.Controls.Add(this.lblTestedBy);
			this.grpRackDate.Controls.Add(this.txtDateTested);
			this.grpRackDate.Controls.Add(this.txtRack);
			this.grpRackDate.Controls.Add(this.lblRack);
			this.grpRackDate.Controls.Add(this.lblDateTested);
			this.grpRackDate.Location = new System.Drawing.Point(288, 88);
			this.grpRackDate.Name = "grpRackDate";
			this.grpRackDate.Size = new System.Drawing.Size(452, 36);
			this.grpRackDate.TabIndex = 4;
			this.grpRackDate.TabStop = false;
			// 
			// txtTestedBy
			// 
			this.txtTestedBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtTestedBy.Location = new System.Drawing.Point(248, 10);
			this.txtTestedBy.Name = "txtTestedBy";
			this.txtTestedBy.ReadOnly = true;
			this.txtTestedBy.Size = new System.Drawing.Size(128, 20);
			this.txtTestedBy.TabIndex = 3;
			this.txtTestedBy.TabStop = false;
			this.txtTestedBy.Text = "";
			// 
			// lblTestedBy
			// 
			this.lblTestedBy.Location = new System.Drawing.Point(192, 10);
			this.lblTestedBy.Name = "lblTestedBy";
			this.lblTestedBy.Size = new System.Drawing.Size(56, 20);
			this.lblTestedBy.TabIndex = 2;
			this.lblTestedBy.Text = "Tested By";
			this.lblTestedBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtDateTested
			// 
			this.txtDateTested.Location = new System.Drawing.Point(72, 10);
			this.txtDateTested.Name = "txtDateTested";
			this.txtDateTested.ReadOnly = true;
			this.txtDateTested.Size = new System.Drawing.Size(112, 20);
			this.txtDateTested.TabIndex = 1;
			this.txtDateTested.TabStop = false;
			this.txtDateTested.Text = "";
			// 
			// txtRack
			// 
			this.txtRack.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtRack.Location = new System.Drawing.Point(412, 10);
			this.txtRack.Name = "txtRack";
			this.txtRack.ReadOnly = true;
			this.txtRack.Size = new System.Drawing.Size(32, 20);
			this.txtRack.TabIndex = 5;
			this.txtRack.TabStop = false;
			this.txtRack.Text = "";
			// 
			// lblRack
			// 
			this.lblRack.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblRack.Location = new System.Drawing.Point(380, 10);
			this.lblRack.Name = "lblRack";
			this.lblRack.Size = new System.Drawing.Size(32, 20);
			this.lblRack.TabIndex = 4;
			this.lblRack.Text = "Rack";
			this.lblRack.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblDateTested
			// 
			this.lblDateTested.Location = new System.Drawing.Point(8, 10);
			this.lblDateTested.Name = "lblDateTested";
			this.lblDateTested.Size = new System.Drawing.Size(68, 20);
			this.lblDateTested.TabIndex = 0;
			this.lblDateTested.Text = "Date Tested";
			this.lblDateTested.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pagePatientTests
			// 
			this.pagePatientTests.Controls.Add(this.pnlTesting);
			this.pagePatientTests.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pagePatientTests.Location = new System.Drawing.Point(4, 23);
			this.pagePatientTests.Name = "pagePatientTests";
			this.pagePatientTests.Size = new System.Drawing.Size(732, 365);
			this.pagePatientTests.TabIndex = 0;
			this.pagePatientTests.Text = "Patient Tests";
			// 
			// pnlTesting
			// 
			this.pnlTesting.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlTesting.Controls.Add(this.dgXMatch);
			this.pnlTesting.Controls.Add(this.pnlTop);
			this.pnlTesting.Controls.Add(this.dgABS);
			this.pnlTesting.Controls.Add(this.dgDAT);
			this.pnlTesting.Controls.Add(this.groupBox1);
			this.pnlTesting.Controls.Add(this.grpTestingValidEntries);
			this.pnlTesting.Location = new System.Drawing.Point(0, 0);
			this.pnlTesting.Name = "pnlTesting";
			this.pnlTesting.Size = new System.Drawing.Size(732, 364);
			this.pnlTesting.TabIndex = 67;
			// 
			// dgXMatch
			// 
			this.dgXMatch.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dgXMatch.ContextMenu = this.contextMenu1;
			this.dgXMatch.Location = new System.Drawing.Point(371, 62);
			this.dgXMatch.Name = "dgXMatch";
			this.dgXMatch.ReactivityPhase = gov.va.med.vbecs.Common.ReactivityPhase.Unknown;
			this.dgXMatch.Size = new System.Drawing.Size(361, 152);
			this.dgXMatch.TabIndex = 7;
			this.dgXMatch.TabStop = true;
			this.dgXMatch.TestDate = new System.DateTime(((long)(0)));
			this.dgXMatch.TestingTech = null;
			// 
			// pnlTop
			// 
			this.pnlTop.Controls.Add(this.dgABORh);
			this.pnlTop.Dock = System.Windows.Forms.DockStyle.Top;
			this.pnlTop.Location = new System.Drawing.Point(0, 0);
			this.pnlTop.Name = "pnlTop";
			this.pnlTop.Size = new System.Drawing.Size(732, 60);
			this.pnlTop.TabIndex = 5;
			this.pnlTop.TabStop = true;
			// 
			// dgABORh
			// 
			this.dgABORh.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dgABORh.ContextMenu = this.contextMenu1;
			this.dgABORh.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgABORh.Location = new System.Drawing.Point(0, 0);
			this.dgABORh.Name = "dgABORh";
			this.dgABORh.OrderedTest = null;
			this.dgABORh.Size = new System.Drawing.Size(732, 64);
			this.dgABORh.TabIndex = 5;
			this.dgABORh.TabStop = true;
			this.dgABORh.TestingDate = new System.DateTime(((long)(0)));
			this.dgABORh.TestingTech = null;
			// 
			// dgABS
			// 
			this.dgABS.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.dgABS.ContextMenu = this.contextMenu1;
			this.dgABS.DATExists = false;
			this.dgABS.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgABS.Location = new System.Drawing.Point(0, 62);
			this.dgABS.Name = "dgABS";
			this.dgABS.OrderedTest = null;
			this.dgABS.ReactivityPhase = gov.va.med.vbecs.Common.ReactivityPhase.All;
			this.dgABS.Size = new System.Drawing.Size(371, 152);
			this.dgABS.TabIndex = 6;
			this.dgABS.TabStop = true;
			this.dgABS.TestDate = new System.DateTime(((long)(0)));
			this.dgABS.TestingTech = null;
			this.dgABS.CellChanged += new gov.va.med.vbecs.GUI.controls.CellChangedEventHandler(this.dgABS_CellChanged);
			// 
			// dgDAT
			// 
			this.dgDAT.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dgDAT.ContextMenu = this.contextMenu1;
			this.dgDAT.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dgDAT.Location = new System.Drawing.Point(0, 214);
			this.dgDAT.Name = "dgDAT";
			this.dgDAT.OrderedTest = null;
			this.dgDAT.Size = new System.Drawing.Size(732, 108);
			this.dgDAT.TabIndex = 8;
			this.dgDAT.TabStop = true;
			this.dgDAT.TestDate = new System.DateTime(((long)(0)));
			this.dgDAT.TestingTech = null;
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.groupBox1.Controls.Add(this.label1);
			this.groupBox1.Controls.Add(this.label2);
			this.groupBox1.Controls.Add(this.label3);
			this.groupBox1.Controls.Add(this.label5);
			this.groupBox1.Controls.Add(this.label6);
			this.groupBox1.Controls.Add(this.label4);
			this.groupBox1.Location = new System.Drawing.Point(0, 320);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(156, 44);
			this.groupBox1.TabIndex = 3;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Key";
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(128, 18);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(24, 16);
			this.label1.TabIndex = 4;
			this.label1.Text = "Error";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label2
			// 
			this.label2.BackColor = System.Drawing.Color.Red;
			this.label2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.label2.Font = new System.Drawing.Font("Arial", 6F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label2.Location = new System.Drawing.Point(112, 18);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(16, 16);
			this.label2.TabIndex = 3;
			this.label2.Text = "E";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label3
			// 
			this.label3.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label3.Location = new System.Drawing.Point(68, 18);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(48, 16);
			this.label3.TabIndex = 2;
			this.label3.Text = "Warning";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label5
			// 
			this.label5.BackColor = System.Drawing.Color.Yellow;
			this.label5.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.label5.Font = new System.Drawing.Font("Arial", 6F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label5.Location = new System.Drawing.Point(52, 18);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(16, 16);
			this.label5.TabIndex = 1;
			this.label5.Text = "W";
			this.label5.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label6
			// 
			this.label6.BackColor = System.Drawing.Color.Lime;
			this.label6.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.label6.CausesValidation = false;
			this.label6.Font = new System.Drawing.Font("Arial", 6F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label6.Location = new System.Drawing.Point(8, 18);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(16, 16);
			this.label6.TabIndex = 0;
			this.label6.Text = "V";
			this.label6.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label4
			// 
			this.label4.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label4.Location = new System.Drawing.Point(24, 18);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(32, 16);
			this.label4.TabIndex = 0;
			this.label4.Text = "Valid";
			this.label4.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpTestingValidEntries
			// 
			this.grpTestingValidEntries.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpTestingValidEntries.Controls.Add(this.lblTestingValidEntries);
			this.grpTestingValidEntries.Location = new System.Drawing.Point(160, 320);
			this.grpTestingValidEntries.Name = "grpTestingValidEntries";
			this.grpTestingValidEntries.Size = new System.Drawing.Size(572, 44);
			this.grpTestingValidEntries.TabIndex = 4;
			this.grpTestingValidEntries.TabStop = false;
			this.grpTestingValidEntries.Text = "Valid Entries";
			// 
			// lblTestingValidEntries
			// 
			this.lblTestingValidEntries.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblTestingValidEntries.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblTestingValidEntries.Location = new System.Drawing.Point(8, 16);
			this.lblTestingValidEntries.Name = "lblTestingValidEntries";
			this.lblTestingValidEntries.Size = new System.Drawing.Size(556, 22);
			this.lblTestingValidEntries.TabIndex = 0;
			this.lblTestingValidEntries.Text = "Valid Entries...";
			this.lblTestingValidEntries.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pageSupplementalTests
			// 
			this.pageSupplementalTests.Controls.Add(this.pnlDATReflex);
			this.pageSupplementalTests.Controls.Add(this.groupBox2);
			this.pageSupplementalTests.Controls.Add(this.groupBox3);
			this.pageSupplementalTests.Controls.Add(this.antigenTypingWeakD);
			this.pageSupplementalTests.Controls.Add(this.groupBox4);
			this.pageSupplementalTests.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageSupplementalTests.Location = new System.Drawing.Point(4, 23);
			this.pageSupplementalTests.Name = "pageSupplementalTests";
			this.pageSupplementalTests.Size = new System.Drawing.Size(732, 365);
			this.pageSupplementalTests.TabIndex = 1;
			this.pageSupplementalTests.Text = "Additional Tests";
			this.pageSupplementalTests.Enter += new System.EventHandler(this.pageSupplementalTests_Enter);
			// 
			// pnlDATReflex
			// 
			this.pnlDATReflex.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlDATReflex.Controls.Add(this.dataGridDATIgG1);
			this.pnlDATReflex.Controls.Add(this.dataGridDATC31);
			this.pnlDATReflex.Location = new System.Drawing.Point(4, 4);
			this.pnlDATReflex.Name = "pnlDATReflex";
			this.pnlDATReflex.Size = new System.Drawing.Size(724, 108);
			this.pnlDATReflex.TabIndex = 100;
			this.pnlDATReflex.SizeChanged += new System.EventHandler(this.pnlDATReflex_SizeChanged);
			// 
			// dataGridDATIgG1
			// 
			this.dataGridDATIgG1.ContextMenu = this.contextMenu1;
			this.dataGridDATIgG1.Location = new System.Drawing.Point(0, 0);
			this.dataGridDATIgG1.Name = "dataGridDATIgG1";
			this.dataGridDATIgG1.OrderedTest = null;
			this.dataGridDATIgG1.Size = new System.Drawing.Size(365, 108);
			this.dataGridDATIgG1.TabIndex = 0;
			this.dataGridDATIgG1.TabStop = true;
			this.dataGridDATIgG1.TestDate = new System.DateTime(((long)(0)));
			this.dataGridDATIgG1.TestingTech = null;
			// 
			// dataGridDATC31
			// 
			this.dataGridDATC31.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.dataGridDATC31.ContextMenu = this.contextMenu1;
			this.dataGridDATC31.Location = new System.Drawing.Point(364, 0);
			this.dataGridDATC31.Name = "dataGridDATC31";
			this.dataGridDATC31.OrderedTest = null;
			this.dataGridDATC31.Size = new System.Drawing.Size(360, 108);
			this.dataGridDATC31.TabIndex = 1;
			this.dataGridDATC31.TabStop = true;
			this.dataGridDATC31.TestDate = new System.DateTime(((long)(0)));
			this.dataGridDATC31.TestingTech = null;
			// 
			// groupBox2
			// 
			this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.groupBox2.Controls.Add(this.label7);
			this.groupBox2.Controls.Add(this.label8);
			this.groupBox2.Controls.Add(this.label9);
			this.groupBox2.Controls.Add(this.label10);
			this.groupBox2.Controls.Add(this.label11);
			this.groupBox2.Controls.Add(this.label12);
			this.groupBox2.Location = new System.Drawing.Point(4, 320);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(156, 44);
			this.groupBox2.TabIndex = 2;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Key";
			// 
			// label7
			// 
			this.label7.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label7.Location = new System.Drawing.Point(128, 18);
			this.label7.Name = "label7";
			this.label7.Size = new System.Drawing.Size(24, 16);
			this.label7.TabIndex = 4;
			this.label7.Text = "Error";
			this.label7.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label8
			// 
			this.label8.BackColor = System.Drawing.Color.Red;
			this.label8.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.label8.Font = new System.Drawing.Font("Arial", 6F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label8.Location = new System.Drawing.Point(112, 18);
			this.label8.Name = "label8";
			this.label8.Size = new System.Drawing.Size(16, 16);
			this.label8.TabIndex = 3;
			this.label8.Text = "E";
			this.label8.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label9
			// 
			this.label9.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label9.Location = new System.Drawing.Point(68, 18);
			this.label9.Name = "label9";
			this.label9.Size = new System.Drawing.Size(48, 16);
			this.label9.TabIndex = 2;
			this.label9.Text = "Warning";
			this.label9.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label10
			// 
			this.label10.BackColor = System.Drawing.Color.Yellow;
			this.label10.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.label10.Font = new System.Drawing.Font("Arial", 6F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label10.Location = new System.Drawing.Point(52, 18);
			this.label10.Name = "label10";
			this.label10.Size = new System.Drawing.Size(16, 16);
			this.label10.TabIndex = 1;
			this.label10.Text = "W";
			this.label10.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label11
			// 
			this.label11.BackColor = System.Drawing.Color.Lime;
			this.label11.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.label11.CausesValidation = false;
			this.label11.Font = new System.Drawing.Font("Arial", 6F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label11.Location = new System.Drawing.Point(8, 18);
			this.label11.Name = "label11";
			this.label11.Size = new System.Drawing.Size(16, 16);
			this.label11.TabIndex = 0;
			this.label11.Text = "V";
			this.label11.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// label12
			// 
			this.label12.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label12.Location = new System.Drawing.Point(24, 18);
			this.label12.Name = "label12";
			this.label12.Size = new System.Drawing.Size(32, 16);
			this.label12.TabIndex = 0;
			this.label12.Text = "Valid";
			this.label12.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// groupBox3
			// 
			this.groupBox3.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox3.Controls.Add(this.lblValidEntriesForAdditionalTests);
			this.groupBox3.Location = new System.Drawing.Point(164, 320);
			this.groupBox3.Name = "groupBox3";
			this.groupBox3.Size = new System.Drawing.Size(564, 44);
			this.groupBox3.TabIndex = 3;
			this.groupBox3.TabStop = false;
			this.groupBox3.Text = "Valid Entries";
			// 
			// lblValidEntriesForAdditionalTests
			// 
			this.lblValidEntriesForAdditionalTests.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblValidEntriesForAdditionalTests.Font = new System.Drawing.Font("Arial", 6.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblValidEntriesForAdditionalTests.Location = new System.Drawing.Point(8, 16);
			this.lblValidEntriesForAdditionalTests.Name = "lblValidEntriesForAdditionalTests";
			this.lblValidEntriesForAdditionalTests.Size = new System.Drawing.Size(548, 22);
			this.lblValidEntriesForAdditionalTests.TabIndex = 0;
			this.lblValidEntriesForAdditionalTests.Text = "Valid Entries...";
			this.lblValidEntriesForAdditionalTests.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// antigenTypingWeakD
			// 
			this.antigenTypingWeakD.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.antigenTypingWeakD.ContextMenu = this.contextMenu1;
			this.antigenTypingWeakD.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.antigenTypingWeakD.Location = new System.Drawing.Point(4, 116);
			this.antigenTypingWeakD.Name = "antigenTypingWeakD";
			this.antigenTypingWeakD.ReactivityPhase = 0;
			this.antigenTypingWeakD.Size = new System.Drawing.Size(724, 164);
			this.antigenTypingWeakD.TabIndex = 3;
			this.antigenTypingWeakD.TabStop = true;
			this.antigenTypingWeakD.TestingDateTime = new System.DateTime(((long)(0)));
			this.antigenTypingWeakD.TestingTech = null;
			// 
			// groupBox4
			// 
			this.groupBox4.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox4.Controls.Add(this.txtLotNumber);
			this.groupBox4.Controls.Add(this.label14);
			this.groupBox4.Controls.Add(this.txtExpirationDate);
			this.groupBox4.Controls.Add(this.label15);
			this.groupBox4.Controls.Add(this.label16);
			this.groupBox4.Controls.Add(this.txtManufacturer);
			this.groupBox4.Location = new System.Drawing.Point(4, 280);
			this.groupBox4.Name = "groupBox4";
			this.groupBox4.Size = new System.Drawing.Size(724, 40);
			this.groupBox4.TabIndex = 1;
			this.groupBox4.TabStop = false;
			// 
			// txtLotNumber
			// 
			this.txtLotNumber.Location = new System.Drawing.Point(72, 12);
			this.txtLotNumber.Name = "txtLotNumber";
			this.txtLotNumber.ReadOnly = true;
			this.txtLotNumber.Size = new System.Drawing.Size(120, 20);
			this.txtLotNumber.TabIndex = 1;
			this.txtLotNumber.TabStop = false;
			this.txtLotNumber.Text = "";
			// 
			// label14
			// 
			this.label14.Location = new System.Drawing.Point(8, 12);
			this.label14.Name = "label14";
			this.label14.Size = new System.Drawing.Size(68, 20);
			this.label14.TabIndex = 0;
			this.label14.Text = "Lot Number";
			this.label14.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtExpirationDate
			// 
			this.txtExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtExpirationDate.Location = new System.Drawing.Point(600, 12);
			this.txtExpirationDate.Name = "txtExpirationDate";
			this.txtExpirationDate.ReadOnly = true;
			this.txtExpirationDate.Size = new System.Drawing.Size(112, 20);
			this.txtExpirationDate.TabIndex = 5;
			this.txtExpirationDate.TabStop = false;
			this.txtExpirationDate.Text = "";
			// 
			// label15
			// 
			this.label15.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.label15.Location = new System.Drawing.Point(552, 12);
			this.label15.Name = "label15";
			this.label15.Size = new System.Drawing.Size(72, 20);
			this.label15.TabIndex = 4;
			this.label15.Text = "Expires";
			this.label15.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// label16
			// 
			this.label16.Location = new System.Drawing.Point(208, 12);
			this.label16.Name = "label16";
			this.label16.Size = new System.Drawing.Size(72, 20);
			this.label16.TabIndex = 2;
			this.label16.Text = "Manufacturer";
			this.label16.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtManufacturer
			// 
			this.txtManufacturer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtManufacturer.Location = new System.Drawing.Point(280, 12);
			this.txtManufacturer.Name = "txtManufacturer";
			this.txtManufacturer.ReadOnly = true;
			this.txtManufacturer.Size = new System.Drawing.Size(264, 20);
			this.txtManufacturer.TabIndex = 3;
			this.txtManufacturer.TabStop = false;
			this.txtManufacturer.Text = "";
			// 
			// tabTesting
			// 
			this.tabTesting.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabTesting.Controls.Add(this.pagePatientTests);
			this.tabTesting.Controls.Add(this.pageSupplementalTests);
			this.tabTesting.Controls.Add(this.pageAntibodyID);
			this.tabTesting.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.tabTesting.ItemSize = new System.Drawing.Size(74, 19);
			this.tabTesting.Location = new System.Drawing.Point(0, 104);
			this.tabTesting.Name = "tabTesting";
			this.tabTesting.SelectedIndex = 0;
			this.tabTesting.Size = new System.Drawing.Size(740, 392);
			this.tabTesting.TabIndex = 4;
			this.tabTesting.TabIndexChanged += new System.EventHandler(this.tabTesting_SelectedIndexChanged);
			this.tabTesting.SelectedIndexChanged += new System.EventHandler(this.tabTesting_SelectedIndexChanged_1);
			// 
			// pageAntibodyID
			// 
			this.pageAntibodyID.Controls.Add(this.antibodyID);
			this.pageAntibodyID.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.pageAntibodyID.Location = new System.Drawing.Point(4, 23);
			this.pageAntibodyID.Name = "pageAntibodyID";
			this.pageAntibodyID.Size = new System.Drawing.Size(732, 365);
			this.pageAntibodyID.TabIndex = 2;
			this.pageAntibodyID.Text = "Antibody ID";
			// 
			// antibodyID
			// 
			this.antibodyID.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.antibodyID.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.antibodyID.Location = new System.Drawing.Point(0, 0);
			this.antibodyID.Name = "antibodyID";
			this.antibodyID.Size = new System.Drawing.Size(732, 364);
			this.antibodyID.TabIndex = 0;
			this.antibodyID.DataChanged += new gov.va.med.vbecs.GUI.controls.CellChangedEventHandler(this.antibodyID_CurrentDataChanged);
			// 
			// FrmRecordTesting
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(742, 533);
			this.Controls.Add(this.btnNext);
			this.Controls.Add(this.cmbName);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnBack);
			this.Controls.Add(this.btnOrderReflex);
			this.Controls.Add(this.btnNewSIorTR);
			this.Controls.Add(this.patientSpecimenDisplayPanel1);
			this.Controls.Add(this.grpRackDate);
			this.Controls.Add(this.tabTesting);
			this.hlphelpChm.SetHelpKeyword(this, "Patient_Testing_General_Instructions.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(750, 560);
			this.Name = "FrmRecordTesting";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Patient Testing";
			this.Controls.SetChildIndex(this.tabTesting, 0);
			this.Controls.SetChildIndex(this.grpRackDate, 0);
			this.Controls.SetChildIndex(this.patientSpecimenDisplayPanel1, 0);
			this.Controls.SetChildIndex(this.btnNewSIorTR, 0);
			this.Controls.SetChildIndex(this.btnOrderReflex, 0);
			this.Controls.SetChildIndex(this.btnBack, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.cmbName, 0);
			this.Controls.SetChildIndex(this.btnNext, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.grpRackDate.ResumeLayout(false);
			this.pagePatientTests.ResumeLayout(false);
			this.pnlTesting.ResumeLayout(false);
			this.pnlTop.ResumeLayout(false);
			this.groupBox1.ResumeLayout(false);
			this.grpTestingValidEntries.ResumeLayout(false);
			this.pageSupplementalTests.ResumeLayout(false);
			this.pnlDATReflex.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.groupBox3.ResumeLayout(false);
			this.groupBox4.ResumeLayout(false);
			this.tabTesting.ResumeLayout(false);
			this.pageAntibodyID.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// FormClosed
		/// </summary>
		public new bool FormClosed
		{
			get
			{
				return this._closeForm;
			}
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Patient Testing";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC056.FrmRecordTesting());
			this.SetThisHelpFile(this.dgXMatch, Common.StrRes.HelpFiles.UC040.FrmRecordTesting());
			this.SetThisHelpFile(this.dgABORh, Common.StrRes.HelpFiles.UC052.FrmRecordTesting());
			this.SetThisHelpFile(this.dgABS, Common.StrRes.HelpFiles.UC053.FrmRecordTesting());
			this.SetThisHelpFile(this.dgDAT, Common.StrRes.HelpFiles.UC054.FrmRecordTesting());
			this.SetThisHelpFile(this.dataGridDATC31, Common.StrRes.HelpFiles.UC054.FrmRecordTesting());
			this.SetThisHelpFile(this.dataGridDATIgG1, Common.StrRes.HelpFiles.UC054.FrmRecordTesting());
			this.SetThisHelpFile(this.antibodyID, Common.StrRes.HelpFiles.UC057.FrmRecordTesting());
			this.SetThisHelpFile(this.antigenTypingWeakD, Common.StrRes.HelpFiles.UC098.FrmRecordTesting());
			//
			this.btnOK.EnabledButton = false;
			//
			this.RequiredFieldsLabel = true;
			this.dgABORh.DivisionCode = LogonUser.LogonUserDivisionCode;
			this.dgABORh.TestingTech = this._testingTechID;
			this.dgABORh.TestingDate = this._testingDateTime;
            //CR 3412
            this.dgABORh.UserRole = ThisUser.CurrentDivisionRole.Role.UserRoleId;

			this.dgDAT.DivisionCode = LogonUser.LogonUserDivisionCode;
			this.dgDAT.TestingTech = this._testingTechID;
			this.dgDAT.TestDate = this._testingDateTime;

			this.dataGridDATIgG1.DivisionCode = LogonUser.LogonUserDivisionCode;
			this.dataGridDATIgG1.TestingTech = this._testingTechID;
			this.dataGridDATIgG1.TestDate = this._testingDateTime;

			this.dataGridDATC31.DivisionCode = LogonUser.LogonUserDivisionCode;
			this.dataGridDATC31.TestingTech = this._testingTechID;
			this.dataGridDATC31.TestDate = this._testingDateTime;

			this.dgABS.DivisionCode = LogonUser.LogonUserDivisionCode;
			this.dgABS.ReactivityPhase = this._reactivityPhase;
			this.dgABS.TestingTech = this._testingTechID;
			this.dgABS.TestDate = this._testingDateTime;

			this.antigenTypingWeakD.DivisionCode = LogonUser.LogonUserDivisionCode;
			this.antigenTypingWeakD.TestingDateTime = this._testingDateTime;
			this.antigenTypingWeakD.TestingTech = this._testingTechID;

			this.dgXMatch.DivisionCode = LogonUser.LogonUserDivisionCode;
			this.dgXMatch.ReactivityPhase = this._reactivityPhase;
			this.dgXMatch.TestingTech = this._testingTechID;
			this.dgXMatch.TestDate = this._testingDateTime;

		}

		/// <summary>
		/// Create the table with patient data
		/// </summary>
		/// <param name="XMTest"></param>
		/// <returns></returns>
		private DataTable GetPatientDataTable(object XMTest)
		{
			BOL.OrderedTest TestOrder = null;
			BOL.OrderedComponent ComponentOrder = null;

			if (XMTest.GetType().ToString().IndexOf("OrderedTest") != -1)
			{
				TestOrder = (BOL.OrderedTest)XMTest;
			}
			else
			{
				ComponentOrder = (BOL.OrderedComponent)XMTest;
			}

			DataTable dt = new DataTable(Common.VbecsTables.Patient.TableName);
			dt.Columns.Add(Common.VbecsTables.Patient.PatientGuid, typeof(Guid));
			dt.Columns.Add(Common.VbecsTables.Patient.PatientLastName);
			dt.Columns.Add(Common.VbecsTables.Patient.PatientFirstName);
			dt.Columns.Add(Common.VbecsTables.Patient.PatientMiddleName);
			dt.Columns.Add(Common.VbecsTables.Patient.PatientSsn);
			dt.Columns.Add(Common.VbecsTables.Patient.BloodTypeCode);
			dt.Columns.Add(Common.VbecsTables.Patient.RhFactorCode);
			dt.Columns.Add(Common.VbecsTables.PatientSpecimen.SpecimenUid);
			dt.Columns.Add(Common.VbecsTables.PatientSpecimen.SpecimenExpirationDate, typeof(DateTime));
			dt.Columns.Add(Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid, typeof(Guid));
            
			DataRow dr = dt.NewRow();

			if (TestOrder != null)
			{
				dr[Common.VbecsTables.Patient.PatientGuid] = TestOrder.Patient.PatientGuid;
				dr[Common.VbecsTables.Patient.PatientLastName] = TestOrder.Patient.LastName;
				dr[Common.VbecsTables.Patient.PatientFirstName] = TestOrder.Patient.FirstName;

				string middleInitial = string.Empty;
				if (TestOrder.Patient.MiddleInitial != null)
					if (TestOrder.Patient.MiddleInitial.Length > 0)
						middleInitial = TestOrder.Patient.MiddleInitial.Substring(0, 1);

				dr[Common.VbecsTables.Patient.PatientMiddleName] = middleInitial;
				//Replaced PatientID with PatientSsn
				dr[Common.VbecsTables.Patient.PatientSsn] = TestOrder.Patient.DisplayPatientID;
				Common.ABO ABO = TestOrder.Patient.AboRh.Abo;
				Common.RH Rh = TestOrder.Patient.AboRh.RH;

				switch (ABO)
				{
					case Common.ABO.A:
						dr[Common.VbecsTables.Patient.BloodTypeCode] = "A";
						break;
					case Common.ABO.B:
						dr[Common.VbecsTables.Patient.BloodTypeCode] = "B";
						break;
					case Common.ABO.AB:
						dr[Common.VbecsTables.Patient.BloodTypeCode] = "AB";
						break;
					case Common.ABO.O:
						dr[Common.VbecsTables.Patient.BloodTypeCode] = "O";
						break;
					case Common.ABO.I:
						dr[Common.VbecsTables.Patient.BloodTypeCode] = "I";
						break;
					default:
						dr[Common.VbecsTables.Patient.BloodTypeCode] = string.Empty;
						break;
				}

				switch (Rh)
				{
					case Common.RH.Positive:
						dr[Common.VbecsTables.Patient.RhFactorCode] = "P";
						break;
					case Common.RH.Negative:
						dr[Common.VbecsTables.Patient.RhFactorCode] = "N";
						break;
					case Common.RH.Inconclusive:
						dr[Common.VbecsTables.Patient.RhFactorCode] = "I";
						break;
					default:
						dr[Common.VbecsTables.Patient.RhFactorCode] = string.Empty;
						break;
				}

				dr[Common.VbecsTables.PatientSpecimen.SpecimenUid] = TestOrder.Specimen.SpecimenUid;
				dr[Common.VbecsTables.PatientSpecimen.SpecimenExpirationDate] = TestOrder.Specimen.SpecimenExpirationDate;
				dr[Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid] = TestOrder.Specimen.SpecimenGuid;
			}
			else if (ComponentOrder != null)
			{
				dr[Common.VbecsTables.Patient.PatientGuid] = ComponentOrder.Patient.PatientGuid;
				dr[Common.VbecsTables.Patient.PatientLastName] = ComponentOrder.Patient.LastName;
				dr[Common.VbecsTables.Patient.PatientFirstName] = ComponentOrder.Patient.FirstName;
				
				string middleInitial = string.Empty;
				if (ComponentOrder.Patient.MiddleInitial != null)
					if (ComponentOrder.Patient.MiddleInitial.Length > 0)
						middleInitial = ComponentOrder.Patient.MiddleInitial.Substring(0, 1);

				dr[Common.VbecsTables.Patient.PatientMiddleName] = middleInitial;
				//Replaced PatientID with PatientSsn
				dr[Common.VbecsTables.Patient.PatientSsn] = ComponentOrder.Patient.DisplayPatientID;
				dr[Common.VbecsTables.Patient.BloodTypeCode] = ComponentOrder.Patient.AboRh.Abo.ToString();
				dr[Common.VbecsTables.Patient.RhFactorCode] = ComponentOrder.Patient.AboRh.RHFactorCode;
				//
				dr[Common.VbecsTables.PatientSpecimen.SpecimenUid] = ComponentOrder.GetSpecimen().SpecimenUid;
				dr[Common.VbecsTables.PatientSpecimen.SpecimenExpirationDate] = ComponentOrder.GetSpecimen().SpecimenExpirationDate;
				dr[Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid] = ComponentOrder.GetSpecimen().SpecimenGuid;
			}

			dt.Rows.Add(dr);

			return dt;
		}

		/// <summary>
		/// Show the patient information and test results / test grids
		/// </summary>
		public void ActivatePatient()
		{
			string ABORh;
			//CR 2805
			string rackName = "";

			if (this.tabTesting.TabPages.Count > 0)
				this.tabTesting.TabPages.Clear();

			if (this._dsPatientTestGrids.Count == 0)
			{
				this._closeForm = true;
				if (this.IsHandleCreated == true)
				{
					this.Close();
				}
			}
			else
			{

				DataSet dsPatientTests = (DataSet)this._dsPatientTestGrids[ActivePatient];
				DataTable dtPatient = dsPatientTests.Tables[Common.VbecsTables.Patient.TableName];

				ABORh = dtPatient.Rows[0][Common.VbecsTables.Patient.BloodTypeCode].ToString() + " " + 
						dtPatient.Rows[0][Common.VbecsTables.Patient.RhFactorCode].ToString();

				this.patientSpecimenDisplayPanel1.Specimen = new BOL.Specimen((Guid)dtPatient.Rows[0][Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid]);

				if (dtPatient.Rows[0].IsNull(Common.VbecsTables.Patient.PatientMiddleName) == true)
				{
					this.cmbName.SelectedIndexChanged -= new System.EventHandler(this.cmbName_SelectedIndexChanged);
					//CR 2667 - used BuildDispalyName method to create the name instead of building it manually
					this.cmbName.Text = BOL.Patient.BuildDisplayName(dtPatient.Rows[0][Common.VbecsTables.Patient.PatientFirstName].ToString(),
																	 "",
																	 dtPatient.Rows[0][Common.VbecsTables.Patient.PatientLastName].ToString());
					this.cmbName.SelectedIndexChanged += new System.EventHandler(this.cmbName_SelectedIndexChanged);
				}
				else
				{
					//CR 2667 - used BuildDispalyName method to create the name instead of building it manually
					this.cmbName.SelectedIndexChanged -= new System.EventHandler(this.cmbName_SelectedIndexChanged);
					this.cmbName.Text = BOL.Patient.BuildDisplayName(dtPatient.Rows[0][Common.VbecsTables.Patient.PatientFirstName].ToString(),
																	 dtPatient.Rows[0][Common.VbecsTables.Patient.PatientMiddleName].ToString(),
																	 dtPatient.Rows[0][Common.VbecsTables.Patient.PatientLastName].ToString());
					this.cmbName.SelectedIndexChanged += new System.EventHandler(this.cmbName_SelectedIndexChanged);
				}

				if (dsPatientTests.Tables.IndexOf("ABORh") != -1 ||
					dsPatientTests.Tables.IndexOf("DAT") != -1 ||
					dsPatientTests.Tables.IndexOf("ABS") != -1 ||
					dsPatientTests.Tables.IndexOf("XM") != -1)
				{
					if (this.tabTesting.TabPages.IndexOf(this.pagePatientTests) == -1)
						this.tabTesting.TabPages.Add(this.pagePatientTests);
				}

				if (dsPatientTests.Tables.IndexOf("DATIgG") != -1 ||
					dsPatientTests.Tables.IndexOf("DATC3d") != -1 ||
					CheckCurrentPatientForAntigenTyping() == true)
				{
					if (this.tabTesting.TabPages.IndexOf(this.pageSupplementalTests) == -1)
						this.tabTesting.TabPages.Add(this.pageSupplementalTests);
				}

				if (dsPatientTests.Tables.IndexOf("ABID") != -1)
				{
					if (this.tabTesting.TabPages.IndexOf(this.pageAntibodyID) == -1)
						this.tabTesting.TabPages.Add(this.pageAntibodyID);
				}

				if (dsPatientTests.Tables.IndexOf("ABORh") == -1)
				{
					this.dgABORh.SetDataSource(new DataTable());
					this.dgABORh.SetGridStatus(false);
				}
				else
				{
					this.dgABORh.SetGridStatus(true);
					this.dgABORh.SetDataSource(dsPatientTests.Tables["ABORh"]);
					this.dgABORh.OrderedTest = this.FindOrderedTest((Guid)dsPatientTests.Tables["ABORh"].Rows[0][ORDEREDTEST.OrderedTestGuid]);
					//CR 2805
					if (this.dgABORh.RackName != null)
						rackName = this.dgABORh.RackName;
				}

				if (dsPatientTests.Tables.IndexOf("ABS") == -1)
				{
					this.dgABS.GridDataSource = new DataTable();
					//CR 2805
					this.dgABS.SetGridStatus(false);
				}
				else
				{
					//CR 2805
					this.dgABS.SetGridStatus(true);
					this.dgABS.GridDataSource = dsPatientTests.Tables["ABS"];
					//this.dgABS.OrderedTest = this.FindOrderedTest((Guid)dsPatientTests.Tables["ABORh"].Rows[0][ORDEREDTEST.OrderedTestGuid]);
					//CR 2805
					if (rackName == "" && this.dgABS.RackName != null)
						rackName = this.dgABS.RackName;
				}

				if (dsPatientTests.Tables.IndexOf("DAT") == -1)
				{
					this.dgDAT.SetDataSource(new DataTable());
					this.dgDAT.SetGridStatus(false);
				}
				else
				{
					this.dgDAT.SetGridStatus(true);
					this.dgDAT.SetDataSource(dsPatientTests.Tables["DAT"]);
					this.dgDAT.OrderedTest = this.FindOrderedTest((Guid)dsPatientTests.Tables["DAT"].Rows[0][ORDEREDTEST.OrderedTestGuid]);
					//CR 2805
					if (rackName == "" && this.dgDAT.RackName != null)
						rackName = this.dgDAT.RackName;
				}

				if (dsPatientTests.Tables.IndexOf("DATIgG") == -1)
				{
					this.dataGridDATIgG1.SetDataSource(new DataTable());
					this.dataGridDATIgG1.SetGridStatus(false);
				}
				else
				{
					this.dataGridDATIgG1.SetGridStatus(true);
					this.dataGridDATIgG1.SetDataSource(dsPatientTests.Tables["DATIgG"]);
					this.dataGridDATIgG1.OrderedTest = this.FindOrderedTest((Guid)dsPatientTests.Tables["DATIgG"].Rows[0][ORDEREDTEST.OrderedTestGuid]);
					//CR 2805
					if (rackName == "" && this.dataGridDATIgG1.RackName != null)
						rackName = this.dataGridDATIgG1.RackName;
				}

				if (dsPatientTests.Tables.IndexOf("DATC3d") == -1)
				{
					this.dataGridDATC31.SetDataSource(new DataTable());
					this.dataGridDATC31.SetGridStatus(false);
				}
				else
				{
					this.dataGridDATC31.SetGridStatus(true);
					this.dataGridDATC31.SetDataSource(dsPatientTests.Tables["DATC3d"]);
					this.dataGridDATC31.OrderedTest = this.FindOrderedTest((Guid)dsPatientTests.Tables["DATC3d"].Rows[0][ORDEREDTEST.OrderedTestGuid]);
					//CR 2805
					if (rackName == "" && this.dataGridDATC31.RackName != null)
						rackName = this.dataGridDATC31.RackName;
				}

				if (dsPatientTests.Tables.IndexOf("ABID") != -1)
				{
					controls.AntibodyID antibodyID = (controls.AntibodyID)this.antibodyIDs[(Guid)dtPatient.Rows[0][Common.VbecsTables.Patient.PatientGuid]];
					this.pageAntibodyID.Controls.Clear();
					this.pageAntibodyID.Controls.AddRange(new System.Windows.Forms.Control[] {
																								 antibodyID});
				}

				if (dsPatientTests.Tables.IndexOf("XM") == -1)
				{
					this.dgXMatch.SetDataSource(new DataTable());
					this.dgXMatch.SetGridStatus(false);
				}
				else
				{
					this.dgXMatch.SetGridStatus(true);
					this.dgXMatch.SetDataSource(dsPatientTests.Tables["XM"]);
					//CR 2805
					if (rackName == "" && this.dgXMatch.RackName != null)
						rackName = this.dgXMatch.RackName;
					//this.dgXMatch.OrderedTest = this.FindOrderedTest((Guid)dsPatientTests.Tables["XM"].Rows[0][ORDEREDTEST.OrderedTestGuid]);
				}

				if (CheckCurrentPatientForAntigenTyping() == true)
				{
					this.antigenTypingWeakD.ClearDataSourceAndTabs();
					this.antigenTypingWeakD.SetGridStatus(true);
					foreach(DataTable dt in dsPatientTests.Tables)
					{
						if (dt.TableName.Substring(0,2) == "AG")
						{
							this.antigenTypingWeakD.AddToDataSource(dt, this.FindOrderedTest((Guid)dt.Rows[0][ORDEREDTEST.OrderedTestGuid]));
						}
					}
					this.antigenTypingWeakD.ActivateAntisera();
					//CR 2805
					if (rackName == "" && this.antigenTypingWeakD.RackName != null)
						rackName = this.antigenTypingWeakD.RackName;
				}
				else
				{
					this.antigenTypingWeakD.ClearDataSourceAndTabs();
					this.antigenTypingWeakD.SetGridStatus(false);
				}

				CheckIfReadyToSave();
				//CR 2805
				this.txtRack.Text = rackName;

			}
		}


		/// <summary>
		/// Checks if the user entered enough data in order to allow him to save
		/// </summary>
		/// <returns></returns>
		private void CheckIfReadyToSave()
		{
			Guid ActivePatientGUID;
			controls.AntibodyID ActiveAntibodyID;
			bool ABORhReadyToSave, DATReadyToSave, ABSReadyToSave, DATIgGReadyToSave, DATCompReadyToSave, AntibodyIDReadyToSave, AntigenTypingReadyToSave, XMReadyToSave;
			string ToolTipMessage = string.Empty;
			bool TAS = false;

			if (_dsPatientTestGrids.Count == 0)
				return;

			DataSet dsPatientTests = (DataSet)this._dsPatientTestGrids[ActivePatient];
			ActivePatientGUID = (Guid)(dsPatientTests.Tables["Patient"].Rows[0][Common.VbecsTables.Patient.PatientGuid]);
			ActiveAntibodyID = (controls.AntibodyID)this.antibodyIDs[ActivePatientGUID];
			
			if (dsPatientTests.Tables.IndexOf("ABORh") != -1)
				ABORhReadyToSave = this.dgABORh.IsReadyToSave();
			else
				ABORhReadyToSave = true;

			if (dsPatientTests.Tables.IndexOf("DAT") != -1)
				DATReadyToSave = this.dgDAT.IsReadyToSave();
			else
				DATReadyToSave = true;

			if (dsPatientTests.Tables.IndexOf("ABS") != -1)
				ABSReadyToSave = this.dgABS.IsReadyToSave();
			else
				ABSReadyToSave = true;

			bool ABORhEmpty = true;
			bool ABSEmpty = true;
			bool DATEmpty = true;
			bool DATIgGEmpty = true;
			bool DATCompEmpty = true;
			bool AntigenTypingEmpty = true;
			bool XMEmpty = true;

			if (dsPatientTests.Tables.IndexOf("ABORh") != -1)
				ABORhEmpty = this.dgABORh.IsGridEmpty();
			else
				ABORhEmpty = true;

			if (dsPatientTests.Tables.IndexOf("ABS") != -1)
				ABSEmpty = this.dgABS.IsGridEmpty();
			else
				ABSEmpty = true;

			if (dsPatientTests.Tables.IndexOf("DAT") != -1)
				DATEmpty = this.dgDAT.IsGridEmpty();
			else
				DATEmpty = true;

			if (dsPatientTests.Tables.IndexOf("XM") != -1)
				XMEmpty = this.dgXMatch.IsGridEmpty();
			else
				XMEmpty = true;

			if (dsPatientTests.Tables.IndexOf("DATIgG") != -1)
				DATIgGEmpty = this.dataGridDATIgG1.IsGridEmpty();
			else
				DATIgGEmpty = true;

			if (dsPatientTests.Tables.IndexOf("DATC3d") != -1)
				DATCompEmpty = this.dataGridDATC31.IsGridEmpty();
			else
				DATCompEmpty = true;

			if (CheckCurrentPatientForAntigenTyping() == true)
				AntigenTypingEmpty = this.antigenTypingWeakD.IsGridEmpty();
			else
				AntigenTypingEmpty = true;

			if (dsPatientTests.Tables.IndexOf("ABORh") != -1)
			{
				if (this.dgABORh.OrderedTest != null)
				{
					if (this.dgABORh.OrderedTest.OrderableTestId == (int)OrderableTest.TAS)
					{
						TAS = true;

						if (ABORhEmpty == true &&
							ABSEmpty == true &&
							DATEmpty == true)
						{
							ABORhReadyToSave = false;
							DATReadyToSave = false;
							ABSReadyToSave = false;
						}
						else
						{
							if (ABORhReadyToSave == false && ABORhEmpty == true)
								ABORhReadyToSave = true;
							if (ABSReadyToSave == false && ABSEmpty == true)
								ABSReadyToSave = true;
							if (DATReadyToSave == false && DATEmpty == true)
								DATReadyToSave = true;
						}
					}
				}
			}

			if (ABORhEmpty == true &&
				ABSEmpty == true &&
				DATEmpty == true &&
				DATIgGEmpty == true &&
				DATCompEmpty == true &&
				AntigenTypingEmpty == true &&
				XMEmpty == true &&
				ActiveAntibodyID == null)
			{
				ABORhReadyToSave = false;
				DATReadyToSave = false;
				ABSReadyToSave = false;
				DATIgGReadyToSave = false;
				DATCompReadyToSave = false;
				AntigenTypingReadyToSave = false;
				XMReadyToSave = false;
			}
			else
			{
				if (!TAS)
				{
					if (ABORhReadyToSave == false && ABORhEmpty == true)
						ABORhReadyToSave = true;
					if (ABSReadyToSave == false && ABSEmpty == true)
						ABSReadyToSave = true;
					if (DATReadyToSave == false && DATEmpty == true)
						DATReadyToSave = true;
				}

				if (dsPatientTests.Tables.IndexOf("XM") != -1)
					XMReadyToSave = this.dgXMatch.IsReadyToSave();
				else
					XMReadyToSave = true;

				if (dsPatientTests.Tables.IndexOf("DATIgG") != -1)
					DATIgGReadyToSave = this.dataGridDATIgG1.IsReadyToSave();
				else
					DATIgGReadyToSave = true;

				if (dsPatientTests.Tables.IndexOf("DATC3d") != -1)
					DATCompReadyToSave = this.dataGridDATC31.IsReadyToSave();
				else
					DATCompReadyToSave = true;

				if (CheckCurrentPatientForAntigenTyping() == true)
					AntigenTypingReadyToSave = this.antigenTypingWeakD.IsReadyToSave();
				else
					AntigenTypingReadyToSave = true;

				if (DATIgGReadyToSave == false && DATIgGEmpty == true)
					DATIgGReadyToSave = true;
				if (DATCompReadyToSave == false && DATCompEmpty == true)
					DATCompReadyToSave = true;
				if (AntigenTypingReadyToSave == false && AntigenTypingEmpty == true)
					AntigenTypingReadyToSave = true;
				if (XMReadyToSave == false && XMEmpty == true)
					XMReadyToSave = true;
			}

			if (ActiveAntibodyID != null)
			{
				AntibodyIDReadyToSave = ActiveAntibodyID.IsReadyToSave();
			}
			else
			{
				AntibodyIDReadyToSave = true;
			}

			if (ABORhReadyToSave == false &&
				this.dgABORh.OrderedTest != null)
			{
				ToolTipMessage += Common.StrRes.Tooltips.UC056.ABORhError().ResString;
				ToolTipMessage += "\n";
			}

			if (DATReadyToSave == false &&
				this.dgDAT.OrderedTest != null)
			{
				ToolTipMessage += Common.StrRes.Tooltips.UC056.DATError().ResString;
				ToolTipMessage += "\n";
			}

			if (ABSReadyToSave == false &&
				this.dgABS.OrderedTest != null)
			{
				ToolTipMessage += Common.StrRes.Tooltips.UC056.ABSError().ResString;
				ToolTipMessage += "\n";
			}

			if (DATIgGReadyToSave == false &&
				this.dataGridDATIgG1.OrderedTest != null)
			{
				ToolTipMessage += Common.StrRes.Tooltips.UC056.DATIgGError().ResString;
				ToolTipMessage += "\n";
			}

			if (DATCompReadyToSave == false &&
				this.dataGridDATC31.OrderedTest != null)
			{
				ToolTipMessage += Common.StrRes.Tooltips.UC056.DATCompError().ResString;
				ToolTipMessage += "\n";
			}

			if (AntibodyIDReadyToSave == false &&
				ActiveAntibodyID != null)
			{
				ToolTipMessage += Common.StrRes.Tooltips.UC056.AntibodyIDError().ResString;
				ToolTipMessage += "\n";
			}

			if (AntigenTypingReadyToSave == false &&
				this.antigenTypingWeakD.ActiveOrder != null)
			{
				ToolTipMessage += Common.StrRes.Tooltips.UC056.AntigenTypingError().ResString;
				ToolTipMessage += "\n";
			}

			if (XMReadyToSave == false &&
				this.dgXMatch.GridExists == true)
			{
				ToolTipMessage += Common.StrRes.Tooltips.UC056.XMError().ResString;
				ToolTipMessage += "\n";
			}

			this.btnOK.SetToolTip(ToolTipMessage);

			if (ABORhReadyToSave == true &&
				DATReadyToSave == true &&
				ABSReadyToSave == true &&
				DATIgGReadyToSave == true &&
				DATCompReadyToSave == true &&
				AntibodyIDReadyToSave == true &&
				AntigenTypingReadyToSave == true &&
				XMReadyToSave == true)
			{
				this.btnOK.EnabledButton = true;
			}
			else
			{
				this.btnOK.EnabledButton = false;
			}

		}

		/// <summary>
		/// Opens the dialog allowing user to choose antigen specificity and phase of reaction for antigen typing
		/// </summary>
		/// <param name="reagent"></param>
		/// <param name="ReactivityPhase"></param>
		private void SelectAntigenTypingSpecificity(BOL.Reagent reagent, int ReactivityPhase)
		{
			int[] phase = new int[1];
			phase[0] = ReactivityPhase;
			reagent.Comments = string.Empty;

			if ( ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator )
			{
				if (this.antigenTypingWeakD.Reagent.ReagentGuid == Guid.Empty)
				{
					Guid activePatientGuid = (Guid)((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables["Patient"].Rows[0][Common.VbecsTables.Patient.PatientGuid];
					DlgPatientAntigenTypingSpecificity dlg = new DlgPatientAntigenTypingSpecificity(ref reagent, ref phase, this._testingDateTime, this._testingTechID, activePatientGuid);

                    dlg.ShowDialogFromLockedParent(this,false);

					if (dlg.DialogResult == DialogResult.Cancel)
					{
						string removedTableName = this.antigenTypingWeakD.RemoveCurrentTab();
						this.antigenTypingWeakD.TabRemoved = false;
						if (removedTableName != string.Empty)
						{
							DataSet dsCurrentPatientOrders = (DataSet)this._dsPatientTestGrids[this.ActivePatient];

							dsCurrentPatientOrders.Tables.RemoveAt(dsCurrentPatientOrders.Tables.IndexOf(removedTableName));

							if (dsCurrentPatientOrders.Tables.Count == 1)
							{
								this._dsPatientTestGrids.RemoveAt(ActivePatient);
								this.cmbName.Items.RemoveAt(ActivePatient);
								if (this.cmbName.Items.Count == 0)
									this.IsDirty = false;
								if (ActivePatient >= this._dsPatientTestGrids.Count)
									ActivePatient = 0;
								ActivatePatient();
							}
							else
							{
								this.antigenTypingWeakD.ActivateAntisera();
							}
						}
					}
					else
					{
						this.antigenTypingWeakD.ReactivityPhase = phase[0];
						this.antigenTypingWeakD.LotNumber = reagent.LotNumber;
						this.antigenTypingWeakD.ExpirationDate = reagent.LotExpirationDate;
						this.antigenTypingWeakD.Manufacturer = reagent.ManufacturerName;
						if (dlg.ExpiredAntiseraException != null)
							this.antigenTypingWeakD.ExpiredAntiseraException = dlg.ExpiredAntiseraException;
						this.antigenTypingWeakD.PhaseChangedComment = reagent.Comments;
						this.antigenTypingWeakD.ReagentGuid = reagent.ReagentGuid;
						this.antigenTypingWeakD.TestMethod = dlg.TestMethod;
						this._testMethod = dlg.TestMethod;
					}
				}
			}
		}

		/// <summary>
		/// Checks if currently active patient has any antigen typing tests assigned
		/// </summary>
		/// <returns></returns>
		private bool CheckCurrentPatientForAntigenTyping()
		{
			if (this._dsPatientTestGrids.Count > 0)
			{
				foreach(DataTable dt in ((DataSet)this._dsPatientTestGrids[this.ActivePatient]).Tables)
				{
					if (dt.TableName.Replace("Repeat", string.Empty).Trim().Substring(0,2) == "AG")
						return true;
				}
			}

			return false;
		}

		/// <summary>
		/// Finds and returns OrderedTest object from the collection of objects
		/// </summary>
		/// <param name="OrderedTestGuid"></param>
		/// <returns></returns>
		private BOL.OrderedTest FindOrderedTest(Guid OrderedTestGuid)
		{
			foreach (object orderedTest in this._orderedTests)
			{
				if (((BOL.OrderedTest)orderedTest).OrderedTestGuid == OrderedTestGuid)
					return (BOL.OrderedTest)orderedTest;
			}

			return null;
		}

		private void groupBox1_Enter(object sender, System.EventArgs e)
		{
		
		}

		private void cmbName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this._dsPatientTestGrids.Count == 0 ||
				this.cmbName.SelectedIndex == -1)
				return;

			this.ActivePatient = cmbName.SelectedIndex;
			ActivatePatient();

			if (this.tabTesting.TabPages.Count > 0)
			{
				if (this.tabTesting.TabPages[0].Equals(this.pageSupplementalTests))
					this.pageSupplementalTests.Focus();
			}
		}

		private void btnNext_Click(object sender, System.EventArgs e)
		{
			if (this._dsPatientTestGrids.Count == 0)
				return;

			if (this.ActivePatient >= this._dsPatientTestGrids.Count - 1)
				this.ActivePatient = 0;
			else
				this.ActivePatient++;

			ActivatePatient();
			if (this.tabTesting.TabPages.Count > 0)
			{
				if (this.tabTesting.TabPages[0].Equals(this.pageSupplementalTests))
					this.pageSupplementalTests.Focus();
			}
		}

		private void btnBack_Click(object sender, System.EventArgs e)
		{
			if (this._dsPatientTestGrids.Count == 0)
				return;

			if (this.ActivePatient <= 0)
				this.ActivePatient = this._dsPatientTestGrids.Count - 1;
			else
				this.ActivePatient--;

			ActivatePatient();
		}

		/// <summary>
		/// Save the result of patient testing
		/// BR_56.01, BR_56.12, BR_56.16
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			Guid ActivePatientGUID;
			Common.TaskStatus componentOrderStatusBeforeSave = Common.TaskStatus.Filled;
			Common.TaskStatus componentOrderStatusAfterSave;

			//CR 2792 Additional check to see if data on the grid are valid
			CheckIfReadyToSave();
			if (this.btnOK.EnabledButton == false)
				return;

            //CR 3356
            ActivePatientGUID = (Guid)((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables[Common.VbecsTables.Patient.TableName].Rows[0][Common.VbecsTables.Patient.PatientGuid];
            BOL.Patient patient = new BOL.Patient(ActivePatientGUID);

            if (((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.IndexOf("ABORh") != -1)
            {
				DataTable dtAboRH = ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables["ABORh"];
                if ((bool)dtAboRH.Rows[0]["AboInterpSave"] == true ||
                     (bool)dtAboRH.Rows[0]["RhInterpSave"] == true)
                {
                    string historicABO = ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables[Common.VbecsTables.Patient.TableName].Rows[0][Common.VbecsTables.Patient.BloodTypeCode].ToString().Trim();
                    string historicRh = ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables[Common.VbecsTables.Patient.TableName].Rows[0][Common.VbecsTables.Patient.RhFactorCode].ToString().Trim();

                    //Get patient's ABO/Rh testing results
                    DataTable dtpatientAboRhHistory = patient.GetPatientAboRHHistory();
                    DataRow[] aboHistory = dtpatientAboRhHistory.Select("(" + Common.VbecsTables.SpecimenTest.BloodTestTypeId + " = 18 OR " +
                                                                      Common.VbecsTables.SpecimenTest.BloodTestTypeId + " = 65 OR " +
                                                                      Common.VbecsTables.SpecimenTest.BloodTestTypeId + " = 118) AND " +
                                                                      Common.VbecsTables.SpecimenTest.TestResultId + " <> ''",
                                                                      Common.VbecsTables.SpecimenTest.TestDate + " DESC");
                    DataRow[] rhHistory = dtpatientAboRhHistory.Select("(" + Common.VbecsTables.SpecimenTest.BloodTestTypeId + " = 21 OR " +
                                                                        Common.VbecsTables.SpecimenTest.BloodTestTypeId + " = 68 OR " +
                                                                        Common.VbecsTables.SpecimenTest.BloodTestTypeId + " = 121) AND " +
                                                                        Common.VbecsTables.SpecimenTest.TestResultId + " <> ''",
                                                                        Common.VbecsTables.SpecimenTest.TestDate + " DESC");

                    if (aboHistory.Length > 0 && rhHistory.Length > 0)
                    {
                        string refreshedABO = aboHistory[0][Common.VbecsTables.BloodUnitTest.TestResultId].ToString().Trim();
                        string refreshedRH = rhHistory[0][Common.VbecsTables.BloodUnitTest.TestResultId].ToString().Trim();

                        if (refreshedABO != historicABO ||
                            refreshedRH != historicRh)
                        {
                            //patient ABO/Rh was modified by someone else, notify the user and close use case
                            GuiMessenger.ShowMessageBox(StrRes.InfoMsg.UC056.RefreshABORh());
                            this.IsDirty = false;
                            this.Close();
                            return;
                        }
                    }
                }
            }

			//BR_56.01
			if (((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.IndexOf("ABORh") != -1 &&
				FindOrderedTest((Guid)((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables["ABORh"].Rows[0][ORDEREDTEST.OrderedTestGuid]).OrderableTest.IndexOf("Repeat") == -1)
			{
				DataTable dtAboRH = ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables["ABORh"];
				if (dtAboRH.Rows[0]["AboInterp"].ToString().Trim() != string.Empty &&
					dtAboRH.Rows[0]["RhInterp"].ToString().Trim() != string.Empty &&
					((bool)dtAboRH.Rows[0]["AboInterpSave"] == true ||
					 (bool)dtAboRH.Rows[0]["RhInterpSave"] == true))
				{
					DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC056.SaveAboRh());
					if (result == DialogResult.No)
						return;
				}
				else
				{
					DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("patient testing"));
					if (result == DialogResult.No)
						return;
				}
			}
			else
			{
				DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("patient testing"));
				if (result == DialogResult.No)
					return;
			}
			
			try
			{
				controls.AntibodyID ActiveAntibodyID;

				ActiveAntibodyID = (controls.AntibodyID)this.antibodyIDs[ActivePatientGUID];

				if (((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.IndexOf("ABID") != -1)
				{	
					ActiveAntibodyID.PrepareAntibodyIDsForSave();
				}
				ArrayList workloadProcessIds;
				if(ActiveAntibodyID != null)
				{
					workloadProcessIds = ActiveAntibodyID.WorkloadProcessIds;
				}
				else
				{
					workloadProcessIds = null;
				}

				ArrayList printBloodUnitGuids = new ArrayList();

				if (((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.IndexOf("XM") != -1)
				{
					DataTable dtXM = ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables["XM"];

					if (dtXM.Rows.Count > 0)
					{
						if (dtXM.Rows[0].IsNull(Common.VbecsTables.OrderedComponent.OrderedComponentGuid) == false)
						{
							componentOrderStatusBeforeSave = BOL.OrderedComponent.GetStatusIncludingUnitsEligibleForIssue((Guid)dtXM.Rows[0][Common.VbecsTables.OrderedComponent.OrderedComponentGuid]);
						}
					}

					foreach(DataRow drXM in dtXM.Rows)
					{
						if (drXM["XMInterp"].ToString().Trim() == "C" ||
							drXM["XMInterp"].ToString().Trim() == "G")
						{
							printBloodUnitGuids.Add((Guid)drXM[Common.VbecsTables.BloodUnit.BloodUnitGuid]);
						}
					}
				}

                //removing empty grids so they are not saved
                bool TAS = false;
                if (this.dgABORh.OrderedTest != null)
                {
                    if (this.dgABORh.OrderedTest.OrderableTestId == (int)OrderableTest.TAS)
                    {
                        TAS = true;
                        //DAT is part of TAS CR 3236 
                        if (this.dgDAT.OrderedTest != null && this.dgDAT.OrderedTest.OrderableTestId == (int)OrderableTest.TAS)
                        {
                            if (this.dgABORh.IsGridEmpty() == true &&
                                this.dgABS.IsGridEmpty() == true &&
                                this.dgDAT.IsGridEmpty() == true)
                            {
                                if (((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Contains("ABORh") == true)
                                {
                                    ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Remove("ABORh");
                                }
                                if (((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Contains("ABS") == true)
                                {
                                    ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Remove("ABS");
                                }
                                if (((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Contains("DAT") == true)
                                {
                                    ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Remove("DAT");
                                }
                            }
                        }
                        //DAT not part of TAS CR 3236
                        else
                        {
                            if (this.dgABORh.IsGridEmpty() == true &&
                                this.dgABS.IsGridEmpty() == true)
                            {
                                if (((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Contains("ABORh") == true)
                                {
                                    ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Remove("ABORh");
                                }
                                if (((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Contains("ABS") == true)
                                {
                                    ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Remove("ABS");
                                }

                            }
                        }
                    }
                }

                if (!TAS)
                {
                    if (this.dgABORh.IsGridEmpty() == true && ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Contains("ABORh") == true)
                    {
                        ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Remove("ABORh");
                    }
                    if (this.dgABS.IsGridEmpty() == true && ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Contains("ABS") == true)
                    {
                        ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Remove("ABS");
                    }
                }

                //CR 3236 check for standalone DAT
                if (this.dgDAT.OrderedTest != null && this.dgDAT.OrderedTest.OrderableTestId != (int)OrderableTest.TAS && this.dgDAT.IsGridEmpty() == true && ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Contains("DAT") == true)
                {
                    ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Remove("DAT");
                }

                if (this.dataGridDATIgG1.IsGridEmpty() == true && ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Contains("DATIgG") == true)
                {
                    ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Remove("DATIgG");
                }
                if (this.dataGridDATC31.IsGridEmpty() == true && ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Contains("DATC3d") == true)
                {
                    ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Remove("DATC3d");
                }
                if (this.dgXMatch.IsGridEmpty() == true && ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Contains("XM") == true)
                {
                    ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Remove("XM");
                }

                if (this.antigenTypingWeakD.IsGridEmpty() == true)
                {
                    for (int i = ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.Count - 1; i >= 0; i--)
                    {
                        if (((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables[i].TableName.Substring(0, 2) == "AG")
                            ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.RemoveAt(i);
                    }
                }

                //this variable indicates whether no workload message should be displayed
                bool bMsgNeeded = false;

                if (BOL.OrderedTest.SaveTestResults((DataSet)this._dsPatientTestGrids[ActivePatient],
                    this._rackNotTestedExceptions, _testingDateTime,
                    _testingTechID, _testMethod, _reactivityPhase, _RackGuid, _automatedInstrumentName,
                    _automatedInstrumentQCd, Common.UpdateFunction.UC056FrmRecordTesting,
                    workloadProcessIds, ActivePatientGUID, this._expiredOrderExceptions, ref bMsgNeeded))
                {

                    if (bMsgNeeded) GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());

                    //printing caution tag and btrf
                    if (printBloodUnitGuids.Count > 0)
                    {
                        DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC040.PrintBTRFandCautionTag());
                        if (result == DialogResult.Yes)
                        {
                            // CR2899 start: release the lock so that UC43 can relock  
                            if (this.LockController.RecordGuids.Count > 0)
                            {
                                this.ReleaseLocks();            //Locking 2.0 the OT would still be locked
                            }
                            // CR2899 end

                            //CR 2493
                            GUI.FrmPrintCautionTagByPatient frm = new GUI.FrmPrintCautionTagByPatient(patient, printBloodUnitGuids);
                            if (frm.IsValid) // CR 3119: form is valid when locks are successful
                            {
                                frm.MdiParent = this.MdiParent;
                                frm.Show();         //All the locks are gone so no need to showfromlockparent
                            }
                        }
                    }

                    //check if component order has been completed and send the completion message to Vista - BR_56.31, CR 2300
                    if (componentOrderStatusBeforeSave != Common.TaskStatus.Filled)
                    {
                        if (((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables.IndexOf("XM") != -1)
                        {
                            DataTable dtXM = ((DataSet)this._dsPatientTestGrids[ActivePatient]).Tables["XM"];

                            if (dtXM.Rows.Count > 0)
                            {
                                if (dtXM.Rows[0].IsNull(Common.VbecsTables.OrderedComponent.OrderedComponentGuid) == false)
                                {
                                    componentOrderStatusAfterSave = BOL.OrderedComponent.GetStatusIncludingUnitsEligibleForIssue((Guid)dtXM.Rows[0][Common.VbecsTables.OrderedComponent.OrderedComponentGuid]);
                                    if (componentOrderStatusAfterSave == Common.TaskStatus.Filled)
                                    {
                                        BOL.OrderedComponent.SendComponentOrderCompletionMessageToVista(dtXM.Rows[0][Common.VbecsTables.OrderedComponent.CprsOrderNumber].ToString());
                                    }
                                }
                            }
                        }
                    }

                    if (this._dsPatientTestGrids.Count > 1)
                    {
                        this._dsPatientTestGrids.RemoveAt(ActivePatient);
                        this.cmbName.Items.RemoveAt(ActivePatient);
                        if (ActivePatient >= this._dsPatientTestGrids.Count)
                            ActivePatient = 0;
                        ActivatePatient();
                    }
                    else
                    {
                        this.IsDirty = false;
                        this.Close();
                    }
                }
                else
                {
                    GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Patient testing results"));
                }
            }
            catch (RowVersionException)
            {
                this.btnOK.RowVersionException = true;		//CR2077
                GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
            }

        }


		private void dgABORh_CurrentCellChanged(object sender, System.EventArgs e)
		{
			this.lblTestingValidEntries.Text = this.dgABORh.ValidEntries;
			CheckIfReadyToSave();
			//Cell has been changed, form is dirty
			this.IsDirty=true;
			this.txtRack.Text = this.dgABORh.RackName;
		}

		private void dgDAT_CurrentCellChanged(object sender, System.EventArgs e)
		{
			this.lblTestingValidEntries.Text = this.dgDAT.ValidEntries;
			CheckIfReadyToSave();
			//Cell has been changed, form is dirty
			this.IsDirty=true;
			this.txtRack.Text = this.dgDAT.RackName;
		}

		private void RowVersionChanged(object sender, System.EventArgs e, byte[] rowVersion)
		{
			if (sender.GetType() == typeof(controls.DataGridAboRH))
			{
				this.dgABS.RowVersionOrderedTest = rowVersion;
				if (this.dgABS.DATExists == true)
					this.dgDAT.RowVersionOrderedTest = rowVersion;
			}
			else if (sender.GetType() == typeof(controls.DataGridAbs))
			{
				if (this.dgABS.OrderedTest.OrderableTestId == (int)Common.OrderableTest.TAS)
					this.dgABORh.RowVersionOrderedTest = rowVersion;
				if (this.dgABS.DATExists == true)
					this.dgDAT.RowVersionOrderedTest = rowVersion;
			}
			else if (sender.GetType() == typeof(controls.DataGridDat))
			{
				this.dgABS.RowVersionOrderedTest = rowVersion;
				if (this.dgDAT.OrderedTest.OrderableTestId == (int)Common.OrderableTest.TAS)
					this.dgABORh.RowVersionOrderedTest = rowVersion;
			}
		}

		private void dgDATIgG_CurrentCellChanged(object sender, System.EventArgs e)
		{
			this.lblValidEntriesForAdditionalTests.Text = this.dataGridDATIgG1.ValidEntries;
			if (this.dataGridDATIgG1.ReagentGuid != Guid.Empty)
			{
				DataRow drReagent = BOL.Reagent.GetReagent(this.dataGridDATIgG1.ReagentGuid);
				this.txtLotNumber.Text = drReagent[Common.VbecsTables.Reagent.LotNumber].ToString();
				this.txtManufacturer.Text = drReagent[Common.VbecsTables.Reagent.ReagentManufacturerName].ToString();
				DateTime expirationDate = (DateTime)drReagent[Common.VbecsTables.Reagent.LotExpirationDate];
				if (expirationDate != DateTime.MinValue)
					this.txtExpirationDate.Text = Common.VBECSDateTime.FormatDateTimeString(expirationDate);
				else
					this.txtExpirationDate.Text = string.Empty;
			}
			else
			{
				this.txtLotNumber.Text = "";
				this.txtManufacturer.Text = "";
				this.txtExpirationDate.Text = "";
			}

			CheckIfReadyToSave();
			//Cell has been changed, form is dirty
			this.IsDirty=true;
			this.txtRack.Text = this.dataGridDATIgG1.RackName;
		}

		private void dgDATC3d_CurrentCellChanged(object sender, System.EventArgs e)
		{
			this.lblValidEntriesForAdditionalTests.Text = this.dataGridDATC31.ValidEntries;
			if (this.dataGridDATC31.ReagentGuid != Guid.Empty)
			{
				DataRow drReagent = BOL.Reagent.GetReagent(this.dataGridDATC31.ReagentGuid);
				this.txtLotNumber.Text = drReagent[Common.VbecsTables.Reagent.LotNumber].ToString();
				this.txtManufacturer.Text = drReagent[Common.VbecsTables.Reagent.ReagentManufacturerName].ToString();
				DateTime expirationDate = (DateTime)drReagent[Common.VbecsTables.Reagent.LotExpirationDate];
				if (expirationDate != DateTime.MinValue)
					this.txtExpirationDate.Text = Common.VBECSDateTime.FormatDateTimeString(expirationDate);
				else
					this.txtExpirationDate.Text = string.Empty;
			}
			else
			{
				this.txtLotNumber.Text = "";
				this.txtManufacturer.Text = "";
				this.txtExpirationDate.Text = "";
			}
			CheckIfReadyToSave();
			//Cell has been changed, form is dirty
			this.IsDirty=true;
			this.txtRack.Text = this.dataGridDATC31.RackName;
		}

		private void antigenTypingWeakD_CurrentCellChanged(object sender, System.EventArgs e)
		{
			this.lblValidEntriesForAdditionalTests.Text = this.antigenTypingWeakD.ValidEntries;
			if (this.antigenTypingWeakD.ReagentGuid != Guid.Empty)
			{
				DataRow drReagent = BOL.Reagent.GetReagent(this.antigenTypingWeakD.ReagentGuid);
				this.txtLotNumber.Text = drReagent[Common.VbecsTables.Reagent.LotNumber].ToString();
				this.txtManufacturer.Text = drReagent[Common.VbecsTables.Reagent.ReagentManufacturerName].ToString();
				DateTime expirationDate = (DateTime)drReagent[Common.VbecsTables.Reagent.LotExpirationDate];
				if (expirationDate != DateTime.MinValue)
					this.txtExpirationDate.Text = Common.VBECSDateTime.FormatDateTimeString(expirationDate);
				else
					this.txtExpirationDate.Text = string.Empty;
			}
			else
			{
				this.txtLotNumber.Text = "";
				this.txtManufacturer.Text = "";
				this.txtExpirationDate.Text = "";
			}

			CheckIfReadyToSave();
			//Cell has been changed, form is dirty
			this.IsDirty=true;
			this.txtRack.Text = this.antigenTypingWeakD.RackName;
		}

		private void antigenTypingWeakD_TabActivated(object sender, EventArgs e, int ReagentTypeId, string ReagentTypeName)
		{
			if (this.IsHandleCreated == true)
			{
				if (this.antigenTypingWeakD.TabRemoved == false)
				{
					BOL.Reagent reagent = new BOL.Reagent();
					reagent.ReagentType.ReagentTypeId = ReagentTypeId;
					reagent.ReagentType.ReagentTypeName = ReagentTypeName;
					if (ReagentTypeId == (int)Common.ReagentType.AntiD)
						this.antigenTypingWeakD.ReactivityPhase = (int)Common.ReactivityPhase.ThreeSevenandAHG;
					else
						this.antigenTypingWeakD.ReactivityPhase = 0;

					this.SelectAntigenTypingSpecificity(reagent, this.antigenTypingWeakD.ReactivityPhase);
				}
			}
		}

		private void dgXM_CurrentCellChanged(object sender, System.EventArgs e)
		{
			this.lblTestingValidEntries.Text = this.dgXMatch.ValidEntries;
			CheckIfReadyToSave();
			//Cell has been changed, form is dirty.
			this.IsDirty=true;
			this.txtRack.Text = this.dgXMatch.RackName;
		}

		private void tabTesting_SelectedIndexChanged(object sender, System.EventArgs e)
		{
		}

		private void antibodyID_CurrentDataChanged(object sender, System.EventArgs e)
		{
			CheckIfReadyToSave();
			//form is dirty
			this.IsDirty=true;
		}

		/// <summary>
		/// BR_2.18
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void dgABS_CellChanged(object sender, System.EventArgs e)
		{
			this.lblTestingValidEntries.Text = this.dgABS.ValidEntries;
			CheckIfReadyToSave();
			//Cell has been changed, form is dirty
			this.IsDirty=true;
			this.txtRack.Text = this.dgABS.RackName;
		}

		private void pageSupplementalTests_Enter(object sender, System.EventArgs e)
		{
			if (this.CheckCurrentPatientForAntigenTyping() == true)
			{
				if (this.antigenTypingWeakD.TabRemoved == false)
				{
				
					BOL.Reagent reagent = this.antigenTypingWeakD.Reagent;
					if (reagent.ReagentGuid == Guid.Empty)
					{
						if (reagent.ReagentType.ReagentTypeId == (int)Common.ReagentType.AntiD)
							this.antigenTypingWeakD.ReactivityPhase = (int)Common.ReactivityPhase.ThreeSevenandAHG;
						else
							this.antigenTypingWeakD.ReactivityPhase = 0;
						this.SelectAntigenTypingSpecificity(this.antigenTypingWeakD.Reagent, this.antigenTypingWeakD.ReactivityPhase);
					}
				}
			}
		}

		private void btnOrderReflex_Click(object sender, System.EventArgs e)
		{
			ArrayList Tests = new ArrayList();
			ArrayList Components = new ArrayList();
			bool cancelForm = true;

			Guid ActivePatientGUID = (Guid)((DataSet)this._dsPatientTestGrids[this.ActivePatient]).Tables[Common.VbecsTables.Patient.TableName].Rows[0][Common.VbecsTables.Patient.PatientGuid];

			foreach (object test in this._orderedTests)
			{
				if (((BOL.OrderedTest)test).Patient.PatientGuid == ActivePatientGUID)
					Tests.Add(test);
			}

			foreach (object component in this._orderedComponents)
			{
				if (((BOL.OrderedComponent)component).Patient.PatientGuid == ActivePatientGUID)
					Components.Add(component);
			}

			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				FrmOrderSpecimenReflex frm = new FrmOrderSpecimenReflex(Tests, Components, ref cancelForm);
				if(cancelForm == false)
				{
					frm.MdiParent = this.MdiParent;
					this.Refresh(); // CR 2845
					frm.ShowFromLockedParent(this, false);     //used to be Show() - before Locking2.0
					frm.WindowState = FormWindowState.Maximized; // CR 2845
				}
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void btnNewSIorTR_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				Guid ActivePatientGUID = (Guid)((DataSet)this._dsPatientTestGrids[this.ActivePatient]).Tables[Common.VbecsTables.Patient.TableName].Rows[0][Common.VbecsTables.Patient.PatientGuid];
				FrmDefineTransfusionReqs frm = new FrmDefineTransfusionReqs(new BOL.Patient(ActivePatientGUID));
				if (frm.DialogResult != DialogResult.Abort)
				{
					frm.MdiParent = this.MdiParent;
					this.Refresh(); // CR 2845
					frm.ShowFromLockedParent(this,true);                 //Locking 2.0 used to be Show()
					frm.WindowState = FormWindowState.Maximized; // CR 2845
				}
				else
					frm.Dispose();
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void patientSpecimenDisplayPanel1_BloodAvailClick(object sender, System.EventArgs e)
		{

		}

		private void patientSpecimenDisplayPanel1_ClinicalInfoClick(object sender, System.EventArgs e)
		{

		}

		private void patientSpecimenDisplayPanel1_MedicationsClick(object sender, System.EventArgs e)
		{
		
		}

		private void patientSpecimenDisplayPanel1_SIAndTRClick(object sender, System.EventArgs e)
		{

		}

		private void patientSpecimenDisplayPanel1_TransHistoryClick(object sender, System.EventArgs e)
		{
		
		}

		private void patientSpecimenDisplayPanel1_VbecsInfoClick(object sender, System.EventArgs e)
		{
		
		}

		private void tabTesting_SelectedIndexChanged_1(object sender, System.EventArgs e)
		{
			if (this.tabTesting.SelectedTab == this.pageSupplementalTests)
			{
				if (this.IsHandleCreated == true)
				{
					if (this.CheckCurrentPatientForAntigenTyping() == true)
					{
						BOL.Reagent reagent = this.antigenTypingWeakD.Reagent;
						if (reagent.ReagentGuid == Guid.Empty)
						{
							if (reagent.ReagentType.ReagentTypeId == (int)Common.ReagentType.AntiD)
								this.antigenTypingWeakD.ReactivityPhase = (int)Common.ReactivityPhase.ThreeSevenandAHG;
							else
								this.antigenTypingWeakD.ReactivityPhase = 0;
							this.SelectAntigenTypingSpecificity(this.antigenTypingWeakD.Reagent, this.antigenTypingWeakD.ReactivityPhase);
						}
					}
				}
			}
		}

		private void menuItem3_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				Guid ActivePatientGUID = (Guid)((DataSet)this._dsPatientTestGrids[this.ActivePatient]).Tables[Common.VbecsTables.Patient.TableName].Rows[0][Common.VbecsTables.Patient.PatientGuid];
				FrmDefineTransfusionReqs frm = new FrmDefineTransfusionReqs(new BOL.Patient(ActivePatientGUID));
				if (frm.DialogResult != DialogResult.Abort)
				{
					frm.MdiParent = this.MdiParent;
					this.Refresh(); // CR 2845
					frm.Show();
					frm.WindowState = FormWindowState.Maximized; // CR 2845
				}
				else
					frm.Dispose();
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void menuItem2_Click(object sender, System.EventArgs e)
		{
			ArrayList Tests = new ArrayList();
			ArrayList Components = new ArrayList();
			bool cancelForm = true;

			if (((System.Windows.Forms.MenuItem)sender).GetContextMenu().SourceControl.Equals(this.dgABORh))
			{
				if (this.dgABORh.OrderedTest != null)
				{
					Tests.Add(this.dgABORh.OrderedTest);
				}
				else
					return;
			}
			else if (((System.Windows.Forms.MenuItem)sender).GetContextMenu().SourceControl.Equals(this.dgABS))
			{
				if (this.dgABS.OrderedTest != null)
				{
					Tests.Add(this.dgABS.OrderedTest);
				}
				else
					return;
			}
			else if (((System.Windows.Forms.MenuItem)sender).GetContextMenu().SourceControl.Equals(this.dgXMatch))
			{
			}
			else if (((System.Windows.Forms.MenuItem)sender).GetContextMenu().SourceControl.Equals(this.dgDAT))
			{
				if (this.dgDAT.OrderedTest != null)
				{
					Tests.Add(this.dgDAT.OrderedTest);
				}
				else
					return;
			}
			else if (((System.Windows.Forms.MenuItem)sender).GetContextMenu().SourceControl.Equals(this.dataGridDATIgG1))
			{
				if (this.dataGridDATIgG1.OrderedTest != null)
				{
					Tests.Add(this.dataGridDATIgG1.OrderedTest);
				}
				else
					return;
			}
			else if (((System.Windows.Forms.MenuItem)sender).GetContextMenu().SourceControl.Equals(this.dataGridDATC31))
			{
				if (this.dataGridDATC31.OrderedTest != null)
				{
					Tests.Add(this.dataGridDATC31.OrderedTest);
				}
				else
					return;
			}
			else if (((System.Windows.Forms.MenuItem)sender).GetContextMenu().SourceControl.Equals(this.antigenTypingWeakD))
			{
				if (this.antigenTypingWeakD.DataSourceTables.Count > 0)
				{
					Tests.Add(this.antigenTypingWeakD.ActiveOrder);
				}
				else
					return;
			}

			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				FrmOrderSpecimenReflex frm = new FrmOrderSpecimenReflex(Tests, Components, ref cancelForm);
				if(cancelForm == false)
				{
					frm.MdiParent = this.MdiParent;
					this.Refresh(); // CR 2845
					frm.Show();
					frm.WindowState = FormWindowState.Maximized; // CR 2845
				}
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		private void menuItem1_Click(object sender, System.EventArgs e)
		{
			if (((System.Windows.Forms.MenuItem)sender).GetContextMenu().SourceControl.Equals(this.dgABORh))
			{
				if (this.dgABORh.OrderedTest != null)
				{
					this.dgABORh.ClearGrid();
				}
				else
					return;
			}
			else if (((System.Windows.Forms.MenuItem)sender).GetContextMenu().SourceControl.Equals(this.dgABS))
			{
				if (this.dgABS.OrderedTest != null)
				{
					this.dgABS.ClearGrid();
				}
				else
					return;
			}
			else if (((System.Windows.Forms.MenuItem)sender).GetContextMenu().SourceControl.Equals(this.dgXMatch))
			{
			}
			else if (((System.Windows.Forms.MenuItem)sender).GetContextMenu().SourceControl.Equals(this.dgDAT))
			{
				if (this.dgDAT.OrderedTest != null)
				{
					this.dgDAT.ClearGrid();
				}
				else
					return;
			}
			else if (((System.Windows.Forms.MenuItem)sender).GetContextMenu().SourceControl.Equals(this.dataGridDATIgG1))
			{
				if (this.dataGridDATIgG1.OrderedTest != null)
				{
					this.dataGridDATIgG1.ClearGrid();
				}
				else
					return;
			}
			else if (((System.Windows.Forms.MenuItem)sender).GetContextMenu().SourceControl.Equals(this.dataGridDATC31))
			{
				if (this.dataGridDATC31.OrderedTest != null)
				{
					this.dataGridDATC31.ClearGrid();
				}
				else
					return;
			}
			else if (((System.Windows.Forms.MenuItem)sender).GetContextMenu().SourceControl.Equals(this.antigenTypingWeakD))
			{
				if (this.antigenTypingWeakD.DataSourceTables.Count > 0)
				{
					this.antigenTypingWeakD.ClearGrid();
				}
				else
					return;
			}
		}

		private void contextMenu1_Popup(object sender, System.EventArgs e)
		{
			if (((System.Windows.Forms.ContextMenu)sender).SourceControl.Equals(this.dgABORh))
			{
				if (this.dgABORh.OrderedTest != null)
				{
					this.menuItem2.Enabled = true;
				}
				else
				{
					this.menuItem2.Enabled = false;
				}

				if (this.dgABORh.enableInvalidation == true)
				{
					this.menuItem1.Enabled = true;
				}
				else
				{
					this.menuItem1.Enabled = false;
				}
			}
			else if (((System.Windows.Forms.ContextMenu)sender).SourceControl.Equals(this.dgABS))
			{
				if (this.dgABS.OrderedTest != null)
				{
					this.menuItem2.Enabled = true;
				}
				else
				{
					this.menuItem2.Enabled = false;
				}

				if (this.dgABS.enableInvalidation == true)
				{
					this.menuItem1.Enabled = true;
				}
				else
				{
					this.menuItem1.Enabled = false;
				}
			}
			else if (((System.Windows.Forms.ContextMenu)sender).SourceControl.Equals(this.dgXMatch))
			{
				if (this.dgXMatch.enableInvalidation == true)
				{
					this.menuItem1.Enabled = true;
				}
				else
				{
					this.menuItem1.Enabled = false;
				}
			}
			else if (((System.Windows.Forms.ContextMenu)sender).SourceControl.Equals(this.dgDAT))
			{
				if (this.dgDAT.OrderedTest != null)
				{
					this.menuItem2.Enabled = true;
				}
				else
				{
					this.menuItem2.Enabled = false;
				}
				if (this.dgDAT.enableInvalidation == true)
				{
					this.menuItem1.Enabled = true;
				}
				else
				{
					this.menuItem1.Enabled = false;
				}
			}
			else if (((System.Windows.Forms.ContextMenu)sender).SourceControl.Equals(this.dataGridDATIgG1))
			{
				if (this.dataGridDATIgG1.OrderedTest != null)
				{
					this.menuItem2.Enabled = true;
				}
				else
				{
					this.menuItem2.Enabled = false;
				}
				if (this.dataGridDATIgG1.enableInvalidation == true)
				{
					this.menuItem1.Enabled = true;
				}
				else
				{
					this.menuItem1.Enabled = false;
				}
			}
			else if (((System.Windows.Forms.ContextMenu)sender).SourceControl.Equals(this.dataGridDATC31))
			{
				if (this.dataGridDATC31.OrderedTest != null)
				{
					this.menuItem2.Enabled = true;
				}
				else
				{
					this.menuItem2.Enabled = false;
				}
				if (this.dataGridDATC31.enableInvalidation == true)
				{
					this.menuItem1.Enabled = true;
				}
				else
				{
					this.menuItem1.Enabled = false;
				}
			}
			else if (((System.Windows.Forms.ContextMenu)sender).SourceControl.Equals(this.antigenTypingWeakD))
			{
				if (this.antigenTypingWeakD.DataSourceTables.Count > 0)
				{
					this.menuItem2.Enabled = true;
				}
				else
				{
					this.menuItem2.Enabled = false;
				}
				if (this.antigenTypingWeakD.enableInvalidation == true)
				{
					this.menuItem1.Enabled = true;
				}
				else
				{
					this.menuItem1.Enabled = false;
				}
			}
		}

		private void pnlDATReflex_SizeChanged(object sender, System.EventArgs e)
		{
			this.dataGridDATC31.Width = (int)(this.pnlDATReflex.Width / 2) - 2;
			this.dataGridDATIgG1.Width = this.dataGridDATC31.Width;
			this.dataGridDATC31.Location = new System.Drawing.Point(this.dataGridDATIgG1.Width+4,0);
		}
	}
}

